/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_BUTTON_H_
#define _LF_BUTTON_H_


#include "mforms/button.h"

#include "lf_view.h"


namespace mforms {
namespace gtk {

class ButtonImpl : public ViewImpl
{
 protected:
  Gtk::Button *_button;
  Gtk::Alignment *_align;
  Gtk::Label *_label;
  Gtk::Image *_icon;
  
  virtual Gtk::Widget *get_outer() const { return _button; }

  ButtonImpl(::mforms::Button *self, ::mforms::ButtonType btype= ::mforms::PushButton, bool concrete= false);
  static void callback(::mforms::Button* self);
  static bool create(::mforms::Button *self, ::mforms::ButtonType btype);
  static void set_text(::mforms::Button *self, const std::string &text);
  static void set_icon(::mforms::Button *self, const std::string &path);
  static void enable_internal_padding(Button *self, bool enabled);

public:
  static void init();
};

}
}

#endif
