/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_TEXTBOX_H_
#define _LF_TEXTBOX_H_

#include <mforms/mforms.h>

#include "lf_view.h"


namespace mforms {
namespace gtk {

class TextBoxImpl : public ViewImpl
{
  Gtk::ScrolledWindow *_swin;
  Gtk::TextView *_text;

  TextBoxImpl(::mforms::TextBox *self, mforms::ScrollBars scroll_type);

  virtual Gtk::Widget *get_outer() const { return _swin; }
  virtual Gtk::Widget *get_inner() const { return _text; }

  static bool create(::mforms::TextBox *self, mforms::ScrollBars scroll_type);
  static void set_text(::mforms::TextBox *self, const std::string &text);
  static void append_text(::mforms::TextBox *self, const std::string &text, bool scroll_to_end);
  static std::string get_text(::mforms::TextBox *self);
  static void set_read_only(::mforms::TextBox *self, bool flag);
  static void set_padding(::mforms::TextBox *self, int pad);
  static void set_bordered(::mforms::TextBox *self, bool flag);
  static void set_monospaced(::mforms::TextBox *self, bool flag);
  static void get_selected_range(::mforms::TextBox *self, int &start, int &end);
  static void clear(::mforms::TextBox *self);

public:
  static void init();
};

  };
};

#endif
