/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_TEXTENTRY_H_
#define _LF_TEXTENTRY_H_

#include <mforms/mforms.h>

#include "lf_view.h"


namespace mforms {
namespace gtk {

class TextEntryImpl : public ViewImpl
{
  Gtk::Entry    *_entry;
  virtual Gtk::Widget *get_outer() const { return _entry; }
  
  TextEntryImpl(::mforms::TextEntry *self, TextEntryType type);
  static bool create(::mforms::TextEntry *self, TextEntryType type);
  static void set_text(::mforms::TextEntry *self, const std::string &text);
  static void set_max_length(::mforms::TextEntry *self, int len);
  static std::string get_text(::mforms::TextEntry *self);
  static void set_read_only(::mforms::TextEntry *self, bool flag);
  void activated(mforms::TextEntry *self);
  bool key_press(GdkEventKey *event, mforms::TextEntry *self);
  
public:
  static void init();
};

  };
};

#endif
