/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "../lf_textentry.h"

namespace mforms {
namespace gtk {

bool TextEntryImpl::create(::mforms::TextEntry *self, TextEntryType type)
{
  return new TextEntryImpl(self, type);
}

void TextEntryImpl::set_text(::mforms::TextEntry *self, const std::string &text)
{
  TextEntryImpl* cb = self->get_data<TextEntryImpl>();

  if ( cb )
  {
    cb->_entry->set_text(text);
  }
}

void TextEntryImpl::set_max_length(::mforms::TextEntry *self, int len)
{
  TextEntryImpl* cb = self->get_data<TextEntryImpl>();

  if ( cb )
  {
    cb->_entry->set_max_length(len);
  }
}

std::string TextEntryImpl::get_text(::mforms::TextEntry *self)
{
  TextEntryImpl* cb = self->get_data<TextEntryImpl>();
  std::string ret("");
  if ( cb )
  {
    ret = cb->_entry->get_text().raw();
  }
  return ret;
}

void TextEntryImpl::set_read_only(::mforms::TextEntry *self, bool flag)
{
  TextEntryImpl* cb = self->get_data<TextEntryImpl>();
  if (cb && cb->_entry)
    cb->_entry->set_editable(!flag);
}

TextEntryImpl::TextEntryImpl(::mforms::TextEntry *self, TextEntryType type)
  : ViewImpl(self)
{
  _entry= Gtk::manage(new Gtk::Entry());
  switch (type)
  {
  case mforms::NormalEntry:
    break;
  case mforms::PasswordEntry:
    _entry->set_visibility(false);
    break;
  case mforms::SearchEntry:
    break;
  }
  _entry->signal_changed().connect(sigc::mem_fun(self, &::mforms::TextEntry::callback));
  _entry->signal_activate().connect(sigc::bind(sigc::mem_fun(this, &TextEntryImpl::activated), self));
  _entry->signal_key_press_event().connect(sigc::bind(sigc::mem_fun(this, &TextEntryImpl::key_press), self));
}

void TextEntryImpl::activated(mforms::TextEntry *self)
{
  self->action(mforms::EntryActivate);
}

bool TextEntryImpl::key_press(GdkEventKey *event, mforms::TextEntry *self)
{
  if (event->keyval == GDK_Up)
  {
    if (event->state & GDK_CONTROL_MASK)
      self->action(mforms::EntryCKeyUp);
    else
      self->action(mforms::EntryKeyUp);
  }
  else if (event->keyval == GDK_Down)
  {
    if (event->state & GDK_CONTROL_MASK)
      self->action(mforms::EntryCKeyDown);
    else
      self->action(mforms::EntryKeyDown);
  }
  return false;
}

void TextEntryImpl::init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

  f->_textentry_impl.create   = &TextEntryImpl::create;
  f->_textentry_impl.set_text = &TextEntryImpl::set_text;
  f->_textentry_impl.set_max_length = &TextEntryImpl::set_max_length;
  f->_textentry_impl.get_text = &TextEntryImpl::get_text;
  f->_textentry_impl.set_read_only= &TextEntryImpl::set_read_only;
}

};
};
