/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */

#include "stdafx.h"
#include <mforms/mforms.h>

using namespace mforms;

Menu::Menu()
{
  _menu_impl= &ControlFactory::get_instance()->_menu_impl;
  
  _menu_impl->create(this);
}


void Menu::remove_item(int i)
{
  _menu_impl->remove_item(this, i);
}


int Menu::add_item(const std::string &caption, const std::string &action)
{
  return _menu_impl->add_item(this, caption, action);
}


int Menu::add_separator()
{
  return _menu_impl->add_separator(this);
}


int Menu::add_submenu(const std::string &caption, Menu *submenu)
{
  return _menu_impl->add_submenu(this, caption, submenu);
}


void Menu::set_item_enabled(int i, bool flag)
{
  _menu_impl->set_item_enabled(this, i, flag);
}


void Menu::set_handler(const sigc::slot<void, const std::string&> &action_handler)
{
  _action_handler = action_handler;
}


void Menu::popup_at(Object *control, int x, int y)
{
  _on_will_show.emit();
  
  _menu_impl->popup_at(this, control, x, y);
}


void Menu::handle_action(const std::string &action)
{
  _action_handler(action);
}

