/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */
#ifndef _MFILECHOOSERS_FILECHOOSER_H_
#define _MFILECHOOSERS_FILECHOOSER_H_

#include <mforms/base.h>
#include <mforms/view.h>
#include <vector>

namespace mforms {
  enum FileChooserType
  {
    OpenFile=  1,
    SaveFile=  2,
    OpenDirectory= 3
  };

  class FileChooser;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
  struct MFORMS_EXPORT FileChooserImplPtrs
  {
    bool (__stdcall *create)(FileChooser *self, FileChooserType type);
    void (__stdcall *set_title)(FileChooser *self, const std::string &title);
    bool (__stdcall *run_modal)(FileChooser *self);
    void (__stdcall *set_directory)(FileChooser *self, const std::string &path);
    std::string (__stdcall *get_directory)(FileChooser *self);
    std::string (__stdcall *get_path)(FileChooser *self);
    void (__stdcall *set_extensions)(FileChooser *self, const std::string &extensions, const std::string &default_extension);
  };
#endif
#endif

  /** A File Picker dialog.
   */
  class MFORMS_EXPORT FileChooser : public View
  {
    FileChooserImplPtrs *_filechooser_impl;
  public:
    /** Constructor.
     
     Type of file chooser may be one of OpenFile, SaveFile or OpenDirectory.
     */
    FileChooser(FileChooserType);

    /** Sets the text to be shown in the title of the dialog window. */
    virtual void set_title(const std::string &title);
    
    /** Shows the dialog and wait for user input. 
     
     Returns true if the user clicks OK, false otherwise. */
    virtual bool run_modal();
    
    /** Set initial directory for the chooser. */
    void set_directory(const std::string &path);
    
    /** Gets the selected path. */
    std::string get_path();
    
    /** Gets the currently selected directory. */
    std::string get_directory();

    /** Set allowed file extensions.
     
     The format is "Foo files (*.foo)|*.foo|SQL Scripts (*.sql)|*.sql"
     default_extension selects the default (ie "foo")
     */
    void set_extensions(const std::string &extensions, const std::string &default_extension);
    
    std::vector<std::pair<std::string, std::string> > split_extensions(const std::string &extensions);
  };
};

#endif
