/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_FILECHOOSER_H_
#define _STUB_FILECHOOSER_H_

#include <mforms/mforms.h>

#include "stub_mforms.h"
#include "stub_view.h"

#define RESPONSE_OK 1
#define RESPONSE_CANCEL 0



namespace mforms {
namespace stub {

class FileChooserImpl : public ViewImpl
{
  static std::vector<std::string> split_string(const std::string &s, const std::string &sep)
  {
    std::vector<std::string> parts;
    std::string ss= s;

    std::string::size_type p;

    if (s.empty())
      return parts;

    p= ss.find(sep);
    while (!ss.empty() && p != std::string::npos)
    {
      parts.push_back(ss.substr(0, p));
      ss= ss.substr(p+sep.size());

      p= ss.find(sep);
    }
    parts.push_back(ss);

    return parts;
  
  }
  
  static bool __stdcall create(::mforms::FileChooser *self, ::mforms::FileChooserType type)
  {
    return true;
  }

  static void __stdcall set_title(::mforms::FileChooser *self, const std::string &title)
  {
  }

  static bool __stdcall show_modal(::mforms::FileChooser *self)
  {
    return true;
  }

  static void __stdcall set_directory(FileChooser *self, const std::string &path)
  {
  }

  static std::string __stdcall get_directory(FileChooser *self)
  {
    return "";
  }


  static std::string __stdcall get_path(FileChooser *self)
  {
    return "";
  }

  static void __stdcall set_extensions(FileChooser *self, const std::string &extensions, const std::string &default_extension)
  {
  }

  FileChooserImpl(::mforms::FileChooser *form, ::mforms::FileChooserType type)
    : ViewImpl(form)
  {
  }

  virtual ~FileChooserImpl()
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_filechooser_impl.create = &FileChooserImpl::create;
    f->_filechooser_impl.set_title = &FileChooserImpl::set_title;
    f->_filechooser_impl.run_modal = &FileChooserImpl::show_modal;
    f->_filechooser_impl.set_extensions = &FileChooserImpl::set_extensions;
    f->_filechooser_impl.set_directory = &FileChooserImpl::set_directory;
    f->_filechooser_impl.get_directory = &FileChooserImpl::get_directory;
    f->_filechooser_impl.get_path = &FileChooserImpl::get_path;
  }
};

};
};

#endif
