/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_PANEL_H_
#define _STUB_PANEL_H_


#include "mforms/panel.h"

#include "stubi_container.h"

namespace mforms
{
namespace stub
{

class PanelImpl : public ContainerImpl
{
protected:
  PanelImpl(::mforms::Panel *self, ::mforms::PanelType type)
    : ContainerImpl(self)
  {
  }


  static bool __stdcall create(::mforms::Panel *self, ::mforms::PanelType type)
  {
    return true;
  }

  static void __stdcall set_title(::mforms::Panel *self, const std::string &title)
  {
  }

  static void __stdcall set_active(::mforms::Panel *self, bool flag)
  {
  }

  
  static bool __stdcall get_active(::mforms::Panel *self)
  {
    return false;
  }

  static void __stdcall set_back_color(::mforms::Panel *self, const std::string &color)
  {
  }


  static void __stdcall set_padding(::mforms::Panel *self, int pad)
  {
  }
  

  static void __stdcall add(::mforms::Panel *self, ::mforms::View *child)
  {
  }

  static void __stdcall remove(::mforms::Panel *self, ::mforms::View *child)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_panel_impl.create         = &PanelImpl::create;
    f->_panel_impl.set_title      = &PanelImpl::set_title;
    f->_panel_impl.set_back_color = &PanelImpl::set_back_color;
    
    f->_panel_impl.set_padding    = &PanelImpl::set_padding;

    f->_panel_impl.add            = &PanelImpl::add;
    f->_panel_impl.remove         = &PanelImpl::remove;
    
    f->_panel_impl.set_active     = &PanelImpl::set_active;
    f->_panel_impl.get_active     = &PanelImpl::get_active;
  }
};

};
};


#endif
