/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_CODE_EDITOR_H_
#define _WF_CODE_EDITOR_H_

/**
 * Implements an mforms wrapper class for the Scintilla editor.
 *
 * @ingroup mforms
 */

#include "mforms/code_editor.h"
#include "wf_view.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class CodeEditorImpl : public ViewImpl
    {
    protected:
      CodeEditorImpl(mforms::CodeEditor *self);

      static bool create(mforms::CodeEditor* self);
      static void set_text(mforms::CodeEditor * self, const std::string& text);
      static const std::string get_text(mforms::CodeEditor* self, bool selection_only);
      static bool has_selection(mforms::CodeEditor* self);
      static void clear_selection(mforms::CodeEditor* self);
      static void set_language(mforms::CodeEditor* self, mforms::SyntaxHighlighterLanguage language);
      static void set_read_only(mforms::CodeEditor* self, bool flag);

      void text_changed(Object^ sender, ScintillaNet::TextModifiedEventArgs^ args);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::CodeEditor*, mgr, f->_code_editor_impl, CodeEditorImpl, create);
        DEF_CALLBACK2(void, mforms::CodeEditor*, const std::string&, mgr, f->_code_editor_impl, CodeEditorImpl, set_text);
        DEF_CALLBACK2(const std::string, mforms::CodeEditor*, bool, mgr, f->_code_editor_impl, CodeEditorImpl, get_text);
        DEF_CALLBACK1(bool, mforms::CodeEditor*, mgr, f->_code_editor_impl, CodeEditorImpl, has_selection);
        DEF_CALLBACK1(void, mforms::CodeEditor*, mgr, f->_code_editor_impl, CodeEditorImpl, clear_selection);
        DEF_CALLBACK2(void, mforms::CodeEditor*, mforms::SyntaxHighlighterLanguage, mgr, f->_code_editor_impl, CodeEditorImpl, set_language);
        DEF_CALLBACK2(void, mforms::CodeEditor*, bool, mgr, f->_code_editor_impl, CodeEditorImpl, set_read_only);
      }
    };

  };
};

#endif // _WF_CODE_EDITOR_H_
