/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// included in wbpublic.wr because of dependency on TreeModel

#ifndef _WF_GRTTREEVIEW_H_
#define _WF_GRTTREEVIEW_H_

#include "grt/tree_model.h"

#include "mforms/grttreeview.h"
#include "mforms/mforms.h"

#include "wf_view.h"

using namespace std;

using namespace System;
using namespace Windows::Forms;
using namespace System::Collections::Generic;

using namespace Aga::Controls::Tree;
using namespace Aga::Controls::Tree::NodeControls;

namespace MySQL {
  namespace Forms {

    private ref struct ColumnEntry
    {
      BindableControl^ nodeControl;
      int column;
      bool editable;
      bool isIcon;

      ColumnEntry(BindableControl^ control, int column, bool editable, bool isIcon)
      {
        this->nodeControl= control;
        this->column= column;
        this->editable= editable;
        this->isIcon= isIcon;
      }
    };

    /**
     * Helper class to forward double clicks for certain tree columns.
     */
    private ref class SwitchNodeIcon: public NodeIcon
    {
    public:
      virtual void MouseDoubleClick(TreeNodeAdvMouseEventArgs^ args) override;
    };

    /**
     * Wrapper for a native .NET treeview control with GRT bec::TreeModel data.
     * We use the TreeViewAdv control as we need multicolumn support.
     */
    public ref class GRTTreeViewImpl : public ViewImpl
    {
    private:
      MySQL::Grt::TreeModel^ _tree_model;
      MySQL::Grt::SimpleGrtTreeModel^ _model;
      List<ColumnEntry^> _columns;

      void add_node_control(BindableControl^ control, int column, bool editable, bool isIcon);

      // Event handlers.
      static void SelectionChanged(System::Object^ sender, EventArgs^ e);
    protected:
      static bool create(::mforms::GRTTreeView *self, bool show_headers);

      static void set_model(::mforms::GRTTreeView*, bec::TreeModel*);

      static int add_column(::mforms::GRTTreeView *self, ::mforms::GRTTreeColumnType type, int model_column, const std::string &title);
      static int add_column_editable(::mforms::GRTTreeView *self, ::mforms::GRTTreeColumnType type, int model_column, const std::string &title);

      static void refresh(mforms::GRTTreeView*, const bec::NodeId &);
      static void set_column_width(mforms::GRTTreeView*, int, int);
      static bool get_selected_node(mforms::GRTTreeView*, bec::NodeId&);
      static int get_selection(mforms::GRTTreeView*, std::vector<bec::NodeId>&);
      static void set_allow_multi_selection(::mforms::GRTTreeView *self, bool flag);

      static void row_count_changed(::mforms::GRTTreeView *self, int old_count);

      void set_model(bec::TreeModel*);
    public:
      GRTTreeViewImpl(::mforms::GRTTreeView *self);
      ~GRTTreeViewImpl();

      int add_column(::mforms::GRTTreeColumnType type, int model_column, String ^name, bool editable);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::GRTTreeView*, bool, mgr, f->_grttreeview_impl, GRTTreeViewImpl, create);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, bec::TreeModel*, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_model);
        DEF_CALLBACK4(int, ::mforms::GRTTreeView*, ::mforms::GRTTreeColumnType, int, const std::string&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, add_column);
        DEF_CALLBACK4(int, ::mforms::GRTTreeView*, ::mforms::GRTTreeColumnType, int, const std::string&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, add_column_editable);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, const bec::NodeId &, mgr, f->_grttreeview_impl, GRTTreeViewImpl, refresh);
        DEF_CALLBACK3(void, ::mforms::GRTTreeView*, int, int, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_column_width);
        DEF_CALLBACK2(bool, ::mforms::GRTTreeView*, bec::NodeId&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, get_selected_node);
        DEF_CALLBACK2(int, ::mforms::GRTTreeView*, std::vector<bec::NodeId>&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, get_selection);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, bool, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_allow_multi_selection);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, int, mgr, f->_grttreeview_impl, GRTTreeViewImpl, row_count_changed);
        
      }
    };
  }
}

#endif // _WF_GRTTREEVIEW_H_