/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_WEBBROWSER_H_
#define _WF_WEBBROWSER_H_


#include "mforms/webbrowser.h"
#include "wf_view.h"

using namespace System::Windows::Forms;
using namespace System::ComponentModel;

namespace MySQL {
  namespace Forms {

    public ref class WebBrowserImpl : public ViewImpl
    {
    protected:
      WebBrowserImpl(::mforms::View *self)
        : ViewImpl(self)
      {
      }

      static bool create(::mforms::WebBrowser *self);
      static void set_html(::mforms::WebBrowser *self, const std::string& code);
      static void navigate(::mforms::WebBrowser *self, const std::string& url);
      static std::string get_document_title(::mforms::WebBrowser *self);

      void DocumentLoaded(Object^ sender, WebBrowserDocumentCompletedEventArgs^ e);
      void OnNewWindow(Object^ sender, CancelEventArgs^ e);
      void StatusTextChanged(Object^ sender, EventArgs^ e);
    public:
      void set_html(const std::string& code);
      void navigate(const std::string& url);
      std::string get_document_title();

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::WebBrowser*, mgr, f->_webbrowser_impl, WebBrowserImpl, create);
        DEF_CALLBACK2(void, ::mforms::WebBrowser*, const std::string&, mgr, f->_webbrowser_impl, WebBrowserImpl, set_html);
        DEF_CALLBACK2(void, ::mforms::WebBrowser*, const std::string&, mgr, f->_webbrowser_impl, WebBrowserImpl, navigate);
        DEF_CALLBACK1(std::string, ::mforms::WebBrowser*, mgr, f->_webbrowser_impl, WebBrowserImpl, get_document_title);
      }
    };

  };
};

#endif // ifndef _WF_WEBBROWSER_H_
