#include "stdafx.h"

#include "testgrt.h"
#include "grt_test_utility.h"
#include "structs.test.h"
#include "grtpp_util.h"

using namespace grt;


BEGIN_TEST_DATA_CLASS(grtpp_util_test)
public:
  GRT grt;
END_TEST_DATA_CLASS

TEST_MODULE(grtpp_util_test, "GRT: util functions");

TEST_FUNCTION(1)
{
  // Load test data.
  grt.load_metaclasses("data/structs.test.xml");
  grt.end_loading_metaclasses();
  ensure_equals("load structs", grt.get_metaclasses().size(), 6U);
}


TEST_FUNCTION(2)
{ // set_value_by_path
  test_BookRef book(&grt);
  bool flag;
  
  flag= set_value_by_path(book, "/title", StringRef("TITLE"));
  ensure("set_value_by_path", flag);
  ensure_equals("set_value_by_path", *book->title(), "TITLE");
  
  flag= set_value_by_path(book, "/", StringRef("TITLE"));
  ensure("set_value_by_path", !flag);
  
  try
  {
    set_value_by_path(book, "/xxx", StringRef("TITLE"));
    ensure("set_value_by_path with bad path", false);
  } catch (grt::bad_item &)
  {
  }

  flag= set_value_by_path(book, "/title/x", StringRef("TITLE"));
  ensure("set_value_by_path with bad path 2", !flag);

  try
  {
    set_value_by_path(book, "/title", IntegerRef(1234));
    ensure("set_value_by_path with bad type", false);
  } catch (grt::type_error &)
  {
  }
}

END_TESTS
