/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _MYSQL_SQL_FACADE_H_
#define _MYSQL_SQL_FACADE_H_


#include "mysql_sql_parser_public_interface.h"
#include "grtsqlparser/sql_facade.h"
#include "mysql_sql_parser_base.h"
#include "grts/structs.db.mysql.h"
#include "grtpp_module_cpp.h"


#define MysqlSqlFacade_VERSION "1.0"
 

/** Implements DBMS specifics.
 * 
 * @ingroup sqlparser
 */
class MYSQL_SQL_PARSER_PUBLIC_FUNC MysqlSqlFacadeImpl
  : public SqlFacade, public grt::ModuleImplBase
{
public:
  MysqlSqlFacadeImpl(grt::CPPModuleLoader *ldr) : grt::ModuleImplBase(ldr) {}

  DEFINE_INIT_MODULE(MysqlSqlFacade_VERSION, "MySQL AB", grt::ModuleImplBase,
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseSqlScriptString),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseSqlScriptStringEx),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseSqlScriptFile),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseSqlScriptFileEx),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseInserts),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseTriggers),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseRoutine),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseRoutines),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseView),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::checkSqlSyntax),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::checkTriggerSyntax),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::checkViewSyntax),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::checkRoutineSyntax),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::renameSchemaReferences),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::splitSqlStatements),
    DECLARE_MODULE_FUNCTION(MysqlSqlFacadeImpl::parseAstFromSqlScript),
    NULL);

  int splitSqlScript(const std::string &sql, std::list<std::string> &statements);

  Sql_parser::Ref sqlParser();
  int parseSqlScriptString(db_CatalogRef catalog, const std::string sql);
  int parseSqlScriptStringEx(db_CatalogRef catalog, const std::string sql, const grt::DictRef options);
  int parseSqlScriptFile(db_CatalogRef catalog, const std::string filename);
  int parseSqlScriptFileEx(db_CatalogRef catalog, const std::string filename, const grt::DictRef options);

  Invalid_sql_parser::Ref invalidSqlParser();
  int parseInserts(db_TableRef table, const std::string sql);
  int parseTriggers(db_TableRef table, const std::string sql);
  int parseRoutine(db_RoutineRef routine, const std::string sql);
  int parseRoutines(db_RoutineGroupRef routineGroup, const std::string sql);
  int parseView(db_ViewRef view, const std::string sql);

  Sql_syntax_check::Ref sqlSyntaxCheck();
  int checkSqlSyntax(const std::string sql);
  int checkTriggerSyntax(const std::string sql);
  int checkViewSyntax(const std::string sql);
  int checkRoutineSyntax(const std::string sql);

  Sql_semantic_check::Ref sqlSemanticCheck();

  Sql_specifics::Ref sqlSpecifics();

  Sql_normalizer::Ref sqlNormalizer();
  std::string normalizeSqlStatement(const std::string sql, const std::string schema_name);
  virtual std::string remove_inter_token_spaces(const std::string sql);

  Sql_inserts_loader::Ref sqlInsertsLoader();

  Sql_schema_rename::Ref sqlSchemaRenamer();
  int renameSchemaReferences(db_CatalogRef catalog, const std::string old_schema_name, const std::string new_schema_name);

  grt::StringListRef splitSqlStatements(const std::string &sql);

  // AST is returned as a list of tree of lists in the format [[symbol-name, value, [child-nodes]], ...], 
  // one list item per statement in the script. If there is a syntax error in the statement, a string with the error
  // message will be there instead of the AST
  grt::BaseListRef parseAstFromSqlScript(const std::string &sql); 

  Sql_statement_decomposer::Ref sqlStatementDecomposer();
};


#endif // _MYSQL_SQL_FACADE_H_
