/* 
 * (c) 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

class SourceSelectPage : public WizardPage
{
public:
  enum SourceType
  {
    ModelSource= 0,
    ServerSource= 1,
    FileSource= 2
  };
  
private:
  struct SourcePart
  {
    mforms::Panel panel;
    mforms::Box box;
    mforms::RadioButton* model_radio;
    mforms::RadioButton* server_radio;
    mforms::RadioButton* file_radio;
    mforms::Box browse_box;
    mforms::FsObjectSelector file_selector;
    
    SourcePart()
      : panel(::mforms::TitledBoxPanel), box(false), browse_box(true), file_selector(true)
    {
      box.set_spacing(4);
      box.set_padding(12);
      box.set_homogeneous(true);
      panel.add(&box);

      int group= RadioButton::new_id();
      model_radio= mforms::manage(new RadioButton(group));
      server_radio= mforms::manage(new RadioButton(group));
      file_radio= mforms::manage(new RadioButton(group));

      box.add(model_radio, false, false);
      model_radio->set_text(_("Model Schemata"));
      box.add(server_radio, false, false);
      server_radio->set_text(_("Live Database Server"));
      file_radio->set_text(_("Script File:"));
      box.add(&browse_box, false, false);
      
      browse_box.set_spacing(8);
      browse_box.add(file_radio, false);
      browse_box.add(&file_selector, true, true);

      file_selector.initialize("", mforms::OpenFile, "SQL Files (*.sql)|*.sql", _("Browse..."));
      file_radio->signal_toggled().connect(sigc::mem_fun(this, &SourcePart::file_source_selected));
    }
    
    void file_source_selected()
    {
      file_selector.set_enabled(file_radio->get_active());
    }
    
    void set_change_slot(const sigc::slot<void> &change_slot)
    {
      model_radio->signal_toggled().connect(change_slot);
      server_radio->signal_toggled().connect(change_slot);
      file_radio->signal_toggled().connect(change_slot);
    }

    SourceType get_source()
    {
      if (model_radio->get_active())
        return ModelSource;
      else if (server_radio->get_active())
        return ServerSource;
      else
        return FileSource;
    }
  };

  SourcePart _left;
  SourcePart _right;

  void left_changed()
  {
    if (_left.model_radio->get_active())
      _right.model_radio->set_enabled(false);
    else
      _right.model_radio->set_enabled(true);

    _left.file_selector.set_enabled(_left.file_radio->get_active());
  }
  
  void right_changed()
  {
    if (_right.model_radio->get_active())
      _left.model_radio->set_enabled(false);
    else
      _left.model_radio->set_enabled(true);

    _right.file_selector.set_enabled(_right.file_radio->get_active());
  }
  
  virtual bool advance()
  {
    const char *sources[]= {
      "model", "server", "file"
    };
    
    values().gset("left_source", sources[get_left_source()]);
    values().gset("right_source", sources[get_right_source()]);
    values().gset("left_source_file", _left.file_selector.get_filename());
    values().gset("right_source_file", _right.file_selector.get_filename());

    if (get_left_source() == SourceSelectPage::FileSource
      && !g_file_test(_left.file_selector.get_filename().c_str(), G_FILE_TEST_EXISTS))
      return false;
      
    if (get_right_source() == SourceSelectPage::FileSource
      && !g_file_test(_right.file_selector.get_filename().c_str(), G_FILE_TEST_EXISTS))
      return false;
        
    return true;
  }


public:
  SourceSelectPage(WizardForm *form)
    : WizardPage(form, "source")
  {
    set_title(_("Select Sources to Compare"));
    set_short_title(_("Select Sources"));

    add(&_left.panel, false, false);
    _left.panel.set_title(_("Source for Left Catalog"));
    _left.model_radio->set_enabled(false);
    _left.server_radio->set_active(true);
    
    _left.set_change_slot(sigc::mem_fun(this,&SourceSelectPage::left_changed));
    _right.set_change_slot(sigc::mem_fun(this,&SourceSelectPage::right_changed));
    
    _right.model_radio->set_active(true);
    
    _left.file_source_selected();
    _right.file_source_selected();
    
    add(&_right.panel, false, false);
    _right.panel.set_title(_("Source for Right Catalog"));
  }

  SourceType get_left_source() { return _left.get_source(); }
  SourceType get_right_source() { return _right.get_source(); }
};
