/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "grt/grt_dispatcher.h"
#include "mysql_routinegroup_editor.h"
#include "string_utilities.h"

using namespace base;

MySQLRoutineGroupEditorBE::MySQLRoutineGroupEditorBE(bec::GRTManager *grtm, const db_mysql_RoutineGroupRef &group, const db_mgmt_RdbmsRef &rdbms)
  : bec::RoutineGroupEditorBE(grtm, group, rdbms)
{
}

std::string MySQLRoutineGroupEditorBE::get_procedure_body()
{
  return strfmt("CREATE PROCEDURE `%s`.`proc`()\nBEGIN\n  \nEND %s\n\n",
    get_schema()->name().c_str(), _non_std_sql_delimiter.c_str());
}

std::string MySQLRoutineGroupEditorBE::get_function_body()
{
  return strfmt("CREATE FUNCTION `%s`.`func`() RETURNS INT\nBEGIN\n  \nEND %s\n\n",
    get_schema()->name().c_str(), _non_std_sql_delimiter.c_str());
}

