/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "grt/tree_model.h"
#include "mysql_schema_editor.h"
#include "grtsqlparser/sql_facade.h"
#include "string_utilities.h"

using namespace base;

MySQLSchemaEditorBE::MySQLSchemaEditorBE(bec::GRTManager *grtm, const db_SchemaRef &schema, const db_mgmt_RdbmsRef &rdbms)
  : bec::SchemaEditorBE(grtm, schema, rdbms)
{
}

void MySQLSchemaEditorBE::refactor_catalog_upon_schema_rename(const std::string &old_name, const std::string &new_name)
{
  try
  {
    //grt::AutoUndo undo(_grtm->get_grt());
    bec::AutoUndoEdit undo(this);

    SqlFacade::instance_for_db_obj(_schema)->renameSchemaReferences(get_catalog(), old_name, new_name);

    undo.end(strfmt(_("Update references to schema: `%s` -> `%s`"), old_name.c_str(), new_name.c_str()));
  }
  catch (std::exception &exc)
  {
    g_warning("Caught exception trying to refactor schema rename: %s", exc.what());
  }
}

