//
//  MySQLRelationshipEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 20/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WBPluginEditorBase.h"

#include "mysql_relationship_editor.h"


@interface DbMysqlRelationshipEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet NSTextField *caption1Edit;
  IBOutlet NSTextField *caption2Edit;
  IBOutlet NSTextView *commentText;
  IBOutlet NSMatrix *visibilityRadios;
  
  IBOutlet NSImageView *previewImage;

  IBOutlet NSTextField *caption1FullText;
  IBOutlet NSTextField *caption2FullText;
  
  IBOutlet NSTextField *caption1Text;
  IBOutlet NSTextField *caption2Text;
  IBOutlet NSTextField *table1NameText;
  IBOutlet NSTextField *table2NameText;
  IBOutlet NSTextField *table1FKText;
  IBOutlet NSTextField *table2FKText;
  IBOutlet NSTextField *table1ColumnText;
  IBOutlet NSTextField *table2ColumnText;
  
  IBOutlet NSButton *mandatory1Check;
  IBOutlet NSButton *mandatory2Check;
  
  IBOutlet NSButton *identifyingCheck;
  
  IBOutlet NSMatrix *cardinalityRadios;
  IBOutlet NSButtonCell *oneToManyRadio;
  IBOutlet NSButtonCell *oneToOneRadio;

  
  RelationshipEditorBE *mBackEnd; //!< schema editor backend
}

- (IBAction)editTable:(id)sender;
- (IBAction)invertRelationship:(id)sender;
- (IBAction)changeVisibility:(id)sender;
- (IBAction)userToggleCheck:(id)sender;
- (IBAction)changeCardinality:(id)sender;

- (id)initWithModule:(grt::Module*)module GRTManager:(bec::GRTManager*)grtm arguments:(const grt::BaseListRef&)args;

- (NSView*)dockableView;


@end
