//
//  MySQLSchemaEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 11/Jan/09.
//  (c) 2009-2010 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WBPluginEditorBase.h"

#include "mysql_schema_editor.h"


// MySQL Schema Editor controller/plugin class. The name of this class must match
// what was declared in ../backend/register_plugin.cpp 
// in schema_editor->moduleFunctionName("DbMysqlSchemaEditor")
// This is the class that will be loaded and instantiated by Workbench
@interface DbMysqlSchemaEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity

  IBOutlet NSTextField *nameText;
  IBOutlet NSPopUpButton *collationPopup;

  IBOutlet NSTextView *commentText;

  MySQLSchemaEditorBE *mBackEnd; //!< schema editor backend
}

- (id)initWithModule:(grt::Module*)module GRTManager:(bec::GRTManager*)grtm arguments:(const grt::BaseListRef&)args;

- (NSView*)dockableView;


@end
