#ifndef __ROUTINE_EDITOR_H__
#define __ROUTINE_EDITOR_H__

#include "mysql_routine_editor.h"
#include "GrtTemplates.h"
#include "grtdb/db_object_helpers.h"

#ifdef _MSC_VER
//#include  <vcclr.h> // .net interop helpers
//using namespace MySQL::Grt;
using namespace System;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
#endif

namespace MySQL {
namespace Grt {
namespace Db {

public ref class MySQLRoutineEditorBE : public RoutineEditorBE
{
protected:
  MySQLRoutineEditorBE(::MySQLRoutineEditorBE *inn)
    : RoutineEditorBE(inn)
  {}

public:
  MySQLRoutineEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
  : RoutineEditorBE(
      new ::MySQLRoutineEditorBE(grtm->get_unmanaged_object(), 
      db_mysql_RoutineRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0)), 
      get_rdbms_for_db_object(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
        )
      )
  {
  }

  ::MySQLRoutineEditorBE *get_unmanaged_object()
  { return static_cast<::MySQLRoutineEditorBE *>(inner); }
  
  String^ get_sql_definition_header()
  { return CppStringToNative(get_unmanaged_object()->get_sql_definition_header()); }
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __ROUTINE_EDITOR_H__