/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "wb_config.h"
#include "db_rev_eng_be.h"
#include "string_utilities.h"

void Db_rev_eng::grtm(bec::GRTManager *grtm)
{
  Db_plugin::grtm(grtm);
  Sql_import::grtm(grtm);
}


std::string Db_rev_eng::task_desc()
{
  return "Reverse engineer database";
}


db_CatalogRef Db_rev_eng::target_catalog()
{
  return Db_plugin::model_catalog();
}


std::string Db_rev_eng::sql_script()
{
  std::string sql_script;
  Db_plugin::dump_ddl(sql_script);
  return sql_script;
}


void Db_rev_eng::parse_sql_script(SqlFacade::Ref sql_parser, db_CatalogRef &catalog, const std::string &sql_script, grt::DictRef &options)
{
  grt::AutoUndo undo(_grtm->get_grt());
  sql_parser->parseSqlScriptStringEx(catalog, sql_script, options);
  undo.end(_("Reverse Engineer Database"));
}


