#ifndef _ADDON_H_
#define _ADDON_H_


#include <vector>
#include <list>


struct Addon
{
  class Version
  {
  public:
    Version(const std::string &version) { parse_str(version); }
    Version() {}
    std::string str() const;
    int compare(const Version &version) const;
    bool operator<(const Version &version) const { return (-1 == compare(version)); }
    bool valid() const { return !partials.empty(); }
    operator std::string() const;

    typedef std::vector<int> Partials;
    void parse_str(const std::string &version);
    Partials partials;
  };

  static std::string Addon::range_version_name(const std::string &guid, const std::string &min_ver, const std::string &max_ver);

  Addon();
  ~Addon();

  std::string manifest_filename();
  std::string package_filename();
  std::string install_log_filename();
  bool valid() const;
  std::string full_name() const;
  void reset();

  std::string guid;
  Version version;
  std::string name;
  std::string description;
  std::string date;
  std::string next_release_date;
  std::string release_notes;
  std::string author;
  std::string platform;
  std::string type;
  int authorization;

  struct Dependency
  {
    std::string guid;
    std::string min_ver;
    std::string max_ver;
  };
  typedef std::vector<Dependency> Dependencies;
  Dependencies dependencies;

  struct Menu_item
  {
    std::string id;
    std::string parent_id;
    std::string name;
    std::string caption;
    std::string item_type;
    std::string command;
  };
  typedef std::vector<Menu_item> Menu_items;
  Menu_items menu_items;

  struct Folder;
  typedef std::vector<Folder> Folders;
  Folders root_folders;

  struct File
  {
    std::string name;
  };
  struct Folder : File
  {
    Folders folders;
    typedef std::vector<File> Files;
    Files files;
  };

  // ext info: info reagarding files compounding the addon + info on menu items
  // ext info is not loaded by Addon_manifest::parse_manifest
  // only by Addon_installer/Addon_uninstaller classes
  bool ext_info_loaded() { return _ext_info_loaded; }
private:
  bool _ext_info_loaded;
};


typedef std::list<Addon *> Addons_list;


#endif // _ADDON_H_
