#ifndef _ADDON_MANAGER_H_
#define _ADDON_MANAGER_H_


#include "addon_repo.h"
#include "file_downloader.h"
#include "logger.h"


class Addon_manager
{
protected:
  static const char *INSTALLED_ADDONS_DIR;
  static const char *CACHED_ADDONS_DIR;

public:
  Addon_manager();
  virtual ~Addon_manager();

  PROPERTY(Logger *, log)

  void load_installed_addons_repo();
  void load_cached_addons_repo();

  void load_manifest(const std::string &guid, const std::string &min_version, const std::string &max_version);
  void load_manifest_from_url(const std::string &url, std::string &guid, std::string &version);

  void download(const std::string &guid, const std::string &version);

  void get_installed_addons(std::list<std::string> &guids, std::list<std::string> &names);
  void install(const std::string &guid, const std::string &version);
  void uninstall(const std::string &guid);

protected:
  Logger *_log;

  File_dir _base_dir;
  File_dir _data_dir;
  File_dir _user_data_dir;
  File_dir _temp_dir;

  Addon_repo _installed_addons;
  Addon_repo _cached_addons;
  File_downloader _fd;
  std::string _url_base;
  std::string _url_suffix;
};


#endif // _ADDON_MANAGER_H_
