#ifndef _ADDON_MANIFEST_LOADER_H_
#define _ADDON_MANIFEST_LOADER_H_


#include "addon_proc_net.h"


class Addon_manifest_loader : public Addon_proc_net
{
public:
  Addon_manifest_loader();
  virtual ~Addon_manifest_loader();

  PROPERTY(std::string, url)
  PROPERTY(std::string, guid)
  PROPERTY(std::string, min_ver)
  PROPERTY(std::string, max_ver)
  PROPERTY(bool, lookup_cached_addons)
  
  void parse_single_manifest(const std::string &filepath);

private:
  virtual void do_ensure_valid_state(std::string &err);
  virtual void do_execute();
  void load(const std::string &guid, const std::string &min_ver, const std::string &max_ver, bool lookup_cached_addons);
  void load(const std::string &url, bool lookup_cached_addons);
  Addon * parse_manifest(const std::string &filepath, bool lookup_cached_addons, bool process_dependencies);

  std::string _url;
  std::string _guid;
  std::string _min_ver;
  std::string _max_ver;
  bool _lookup_cached_addons;
};


#endif // _ADDON_MANIFEST_LOADER_H_
