#include "stdafx.h"
#include "addon_proc_net.h"


Addon_proc_net::Addon_proc_net()
:
_fd(NULL)
{
}


Addon_proc_net::~Addon_proc_net()
{
}


void Addon_proc_net::cancel()
{
  if (_fd)
    _fd->cancel_download();
}


void Addon_proc_net::do_ensure_valid_state(std::string &err)
{
  Addon_proc::do_ensure_valid_state(err);

  if (!err.empty())
    return;
  else if (!_fd)
    err= "Downloader was not set.";
}


void Addon_proc_net::download()
{
  if (!_fd->download())
  {
    std::string msg;
    if (_fd->cancelled())
      msg= "Download process was cancelled.";
    else
      msg= "Failed to download file: " + File(_fd->filepath()).name()
        + ".\nFor details see log file: " + File(_fd->log_filepath()).quoted_path() + ".";
    _log->throw_err(msg);
  }
}
