#ifndef _GRT_LOGGER_H_
#define _GRT_LOGGER_H_


#include "logger.h"
#include "grt/grt_manager.h"


class Grt_logger : public Logger
{
public:
  static Grt_logger * default_instance();

  Grt_logger() : _grtm(NULL), _callbacks_enabled(true) {}
  Grt_logger(bec::GRTManager *grtm) : _grtm(grtm), _callbacks_enabled(true) {}

  PROPERTY_I(bec::GRTManager *, grtm)
  PROPERTY(bool, callbacks_enabled)

  typedef sigc::slot<int, int, const std::string&> Task_msg_cb;
  typedef sigc::slot<int, float, const std::string&> Task_progress_cb;
  typedef sigc::slot<int> Task_finish_cb;
  typedef sigc::slot<int, const std::string&> Task_fail_cb;

  PROPERTY_I(Task_msg_cb, task_msg_cb)
  PROPERTY_I(Task_progress_cb, task_progress_cb)
  PROPERTY_I(Task_finish_cb, task_finish_cb)
  PROPERTY_I(Task_fail_cb, task_fail_cb)

  int process_download_progress(double dltotal, double dlnow);

  void process_task_msg(const grt::Message &msg);
  void process_task_finish(grt::ValueRef res);
  void process_task_fail(const std::exception &error);

  class Scope_callbacks_disabler
  {
  public:
    Scope_callbacks_disabler(Grt_logger *logger) : _logger(logger), _callbacks_enabled(_logger->callbacks_enabled()) { _logger->callbacks_enabled(false); }
    ~Scope_callbacks_disabler() { _logger->callbacks_enabled(_callbacks_enabled); }
  private:
    Grt_logger *_logger;
    bool _callbacks_enabled;
  };

private:
  bec::GRTManager *_grtm;
  bool _callbacks_enabled;

  Task_msg_cb _task_msg_cb;
  Task_progress_cb _task_progress_cb;
  Task_finish_cb _task_finish_cb;
  Task_fail_cb _task_fail_cb;

  virtual void do_push_info(const std::string &text);
  virtual void do_push_warn(const std::string &text);
  virtual void do_push_err(const std::string &text);
};


#endif // _GRT_LOGGER_H_
