#include "stdafx.h"

#include <iostream>
#include "logger.h"


Logger * Logger::default_instance()
{
  static Logger logger;
  return &logger;
}


Logger::Logger()
:
_enabled(true)
{
}


Logger::~Logger()
{
}


void Logger::push_info(const std::string &text)
{
  if (enabled() && !text.empty())
    do_push_info(text);
}


void Logger::push_warn(const std::string &text)
{
  if (enabled() && !text.empty())
    do_push_warn(text);
}


void Logger::push_err(const std::string &text)
{
  if (enabled() && !text.empty())
    do_push_err(text);
}


void Logger::throw_err()
{
  do_throw_err(std::string());
}


void Logger::throw_err(const std::string &text)
{
  do_throw_err(text);
}


void Logger::do_push_info(const std::string &text)
{
  std::cout << text << std::endl;
}


void Logger::do_push_warn(const std::string &text)
{
  std::cout << text << std::endl;
}


void Logger::do_push_err(const std::string &text)
{
  std::cerr << text << std::endl;
}


void Logger::do_throw_err(const std::string &text)
{
  throw std::runtime_error(text);
}
