/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 *
 * Code generated by this tool is covered by the LGPL version 2,
 * or (at your option) any later version
 */


#include "grtpp.h"
#include "grtpp_helper.h"

#include <glib.h>

using namespace grt;



int main(int argc, char **argv)
{
  GRT grt;
  std::string structs_file= argv[1];
  std::string structs_dir= argv[2];
  std::string output_dir= argv[3];
  std::string impl_output_dir= argv[4];
  
  std::multimap<std::string,std::string> requires;

  g_print("Reading structs from '%s', outputing classes to '%s'\n",
            structs_dir.c_str(), output_dir.c_str());
  
  grt.scan_metaclasses_in(structs_dir, &requires);
  grt.end_loading_metaclasses(false);

  helper::generate_struct_code(&grt, structs_file, output_dir, impl_output_dir, requires);

  return 0;
}
