#ifndef _CANVAS_FLOATER_H_
#define _CANVAS_FLOATER_H_

#include "mdc.h"

namespace wbfig { class Titlebar; };

namespace wb {

class Button : public mdc::Button
{
public:
  Button(mdc::Layer *layer);

  virtual void draw_contents(mdc::CairoCtx *cr);
};


class Floater : public mdc::Box
{
  typedef mdc::Box super;
public:
  Floater(mdc::Layer *layer, const std::string &title);
  virtual ~Floater();

  void set_title(const std::string &title);

protected:
  wbfig::Titlebar *_title;
  mdc::Box _content_box;

private:
  mdc::Point _drag_offset;
  bool _dragging;

  void update_position();

  virtual bool on_button_press(mdc::CanvasItem *target, const mdc::Point &point, mdc::MouseButton button, mdc::EventState state);
  virtual bool on_button_release(mdc::CanvasItem *target, const mdc::Point &point, mdc::MouseButton button, mdc::EventState state);
  virtual bool on_drag(mdc::CanvasItem *target, const mdc::Point &point, mdc::EventState state);
};

};

#endif
