#ifndef _MINI_VIEW_H_
#define _MINI_VIEW_H_


#include "wbcanvas/base_bridge.h"

namespace mdc 
{
  class CanvasView;
  struct Point;
  struct CairoCtx;
};

namespace wb 
{
  class MiniView : public mdc::Figure
  {
    mdc::CanvasView *_canvas_view;
    model_DiagramRef _model_diagram;

    mdc::Point _click_pos;

    bool _updating_viewport;
    bool _skip_viewport_update;

    mdc::RectangleFigure *_viewport_figure;

    sigc::connection _view_repaint_connection;
    sigc::connection _view_viewport_change_connection;

    void render_figure(mdc::CairoCtx *cr, const model_FigureRef &elem);
    void render_layer(mdc::CairoCtx *cr, const model_LayerRef &layer, bool draw);
    virtual void draw_contents(mdc::CairoCtx *cr);

    void viewport_changed();

    void viewport_dragged(const mdc::Rect &rect);

    mdc::Rect get_scaled_target_bounds(double &scale);

    bool view_button_cb(mdc::CanvasView*, mdc::MouseButton, bool, mdc::Point, mdc::EventState);
    bool view_motion_cb(mdc::CanvasView*, mdc::Point, mdc::EventState);

  public:
    MiniView(mdc::Layer *output_layer);
    virtual ~MiniView();
    
    void update_size();
    void set_active_view(mdc::CanvasView *canvas_view, const model_DiagramRef &model_diagram);
  };
};

#endif /* _MINI_VIEW_H_ */
