/*
 *  wb_context_model.h
 *  MySQLWorkbench
 *
 *  Created by Alfredo Kojima on 29/Apr/09.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */

#ifndef _WBCONTEXT_MODEL_H_
#define _WBCONTEXT_MODEL_H_


#include "workbench/wb_backend_public_interface.h"


#include "wbcanvas/model_model_impl.h"

#include <grts/structs.app.h>
#include <grts/structs.model.h>
#include <grts/structs.workbench.h>

namespace wb 
{
  class WBContextUI;
  class ModelDiagramForm;
  class PhysicalOverviewBE;
  
  class MYSQLWBBACKEND_PUBLIC_FUNC WBContextModel : public sigc::trackable, public ModelBridgeDelegate
  {    
  public:
    WBContextModel(WBContextUI *wbui);
    virtual ~WBContextModel();
    
  public:
    WBContextUI *get_wbui() { return _wbui; }
    PhysicalOverviewBE *get_overview() { return _overview; }
    
    model_DiagramRef get_active_model_diagram(bool main_form);
    model_ModelRef get_active_model(bool main_form);
    
    // return the named toolbar
    grt::ListRef<app_ToolbarItem> get_toolbar_items(const std::string &name);
    
    void model_created(workbench_DocumentRef doc);
    void model_loaded(workbench_DocumentRef doc);
    
    void register_diagram_form(ModelDiagramForm *view);
    
    ModelDiagramForm *get_diagram_form_for_diagram_id(const std::string &id) { return _model_forms[id]; }
    ModelDiagramForm *get_diagram_form(mdc::CanvasView *view);
    
    void notify_diagram_created(ModelDiagramForm *view);
    void notify_diagram_destroyed(ModelDiagramForm *view);
    
    void realize();
    void unrealize();
    
    void activate_canvas_object(const model_ObjectRef &object, int flags);
    
    void update_page_settings();
  public:
    void update_plugin_arguments_pool(bec::ArgumentPool &args);
    
    int get_object_list_popup_items(bec::UIForm *form, const std::vector<bec::NodeId> &nodes,
                                    const grt::ListRef<GrtObject> &objects,
                                    const std::string &label, const std::list<std::string> &groups, bec::MenuItemList &items);
    
    
  private:
    // delegate functions from ModelBridgeDelegate
    virtual cairo_surface_t *fetch_image(const std::string &file);
    virtual std::string attach_image(const std::string &file);
    virtual void release_image(const std::string &name);
    
    virtual mdc::CanvasView *create_diagram(const model_DiagramRef &view);
    virtual void free_canvas_view(mdc::CanvasView *view);
    
    mdc::CanvasView* create_diagram_main(const model_DiagramRef &mview);
        
    void update_current_diagram(bec::UIForm *form);
    
    void diagram_object_changed(const std::string &member, const grt::ValueRef &ovalue, ModelDiagramForm *view);
    void diagram_object_list_changed(grt::internal::OwnedList *list, bool added, const grt::ValueRef &value, ModelDiagramForm *vform);

    bool has_selected_model();
    bool has_selected_schema();
    void add_model_schema();
    void add_model_table();
    void add_model_view();
    void add_model_rgroup();
    void add_model_diagram();

    void page_settings_changed(const std::string &field, const grt::ValueRef &value);
    
    int add_object_plugins_to_popup_menu(const grt::ListRef<GrtObject> &objects,
                                         const std::list<std::string> &groups, bec::MenuItemList &items);
        
  private:
    WBContextUI *_wbui;
    PhysicalOverviewBE *_overview;
    app_ToolbarRef _toolbar;
    app_ToolbarRef _tools_toolbar;

    workbench_DocumentRef _doc;
    sigc::connection _page_settings_conn;

    std::map<std::string, ModelDiagramForm*> _model_forms;
  };
};

#endif
