#include "stdafx.h"

#include "wb_sqlide_module.h"
#include "sqlide/recordset_text_storage.h"
#include <map>


using namespace bec;
using namespace grt;


#define MODULE_VERSION "1.0.0"


grt::ListRef<app_Plugin> WbSqlIdeImpl::getPluginInfo()
{
  grt::ListRef<app_Plugin> list(get_grt());
  GRT *grt= get_grt();
  app_PluginRef plugin(grt);


#define REGISTER_DATA_STORAGE(data_format, desc)\
{\
  plugin= app_PluginRef(grt);\
  plugin->name(Recordset_data_storage::DATA_STORAGE_MODULE_NAME_PREFIX + data_format);\
  plugin->caption("Get "data_format" data storage");\
  plugin->description(desc);\
  plugin->moduleName("WbSqlIde");\
  plugin->moduleFunctionName(Recordset_data_storage::DATA_STORAGE_MODULE_GETTER);\
  plugin->pluginType("custom:com.mysql.sql");\
  plugin->showProgress(1);\
  plugin->groups().insert(Recordset_data_storage::DATA_STORAGE_MODULE_GROUP);\
  list.insert(plugin);\
}

  REGISTER_DATA_STORAGE("CSV", "CSV")
  REGISTER_DATA_STORAGE("CSV_semicolon", "CSV (; separated)")
  REGISTER_DATA_STORAGE("tab", "Tab separated")
  REGISTER_DATA_STORAGE("HTML", "HTML")
  REGISTER_DATA_STORAGE("XML", "XML")
  REGISTER_DATA_STORAGE("SQL_inserts", "SQL INSERT statements")
  
  return list;
}


Recordset_data_storage::Ref WbSqlIdeImpl::getDataStorage(const std::string &data_format)
{
  static std::map<std::string, Recordset_text_storage::Ref> data_storages;

  Recordset_text_storage::Ref ds= data_storages[data_format];
  if (!ds)
  {
    GRTManager *grtm= GRTManager::get_instance_for(get_grt());
    ds= Recordset_text_storage::create(grtm);
    ds->data_format(data_format);
  }
  return ds;
}


GRT_MODULE_ENTRY_POINT(WbSqlIdeImpl);
