#ifndef _STDAFX_H_
#define _STDAFX_H_

#ifdef _WIN32

// Define this scope here to avoid that the PCRE lib declares locally defined things as extern.
//#define PCRE_DATA_SCOPE 
#define PCRE_STATIC

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>

#define snprintf _snprintf

#include <sigc++/sigc++.h>
#include <glib.h>
#include <string>
#include <vector>
#include <stdexcept>
#include <stdarg.h>
#include <algorithm>
#include <map>
#include <list>
#include <sstream>
#include <cctype>
#include <pcre.h>
#include <algorithm>

#define _USE_MATH_DEFINES
#include <math.h>

#include <cairo/cairo.h>
#include <cairo/cairo-pdf.h>
#include <cairo/cairo-ps.h>
#include <cairo/cairo-svg.h>

#include <gl/gl.h>

#else // !_WIN32

#ifndef __APPLE__

#include <sigc++/sigc++.h>
#include <glib.h>
#include <string>
#include <vector>
#include <stdexcept>
#include <stdarg.h>
#include <algorithm>
#include <map>
#include <list>
#include <sstream>
#include <cctype>
#include <pcre.h>
#include <algorithm>
#include <boost/shared_ptr.hpp>
#include "grtpp.h"
#include "grtpp_util.h"
#include "grt/common.h"

#include "grts/structs.app.h"
#include "grts/structs.db.h"
#include "grts/structs.db.maxdb.h"
#include "grts/structs.db.mgmt.h"
#include "grts/structs.db.mysql.h"
#include "grts/structs.db.query.h"
#include "grts/structs.h"
#include "grts/structs.model.h"
#include "grts/structs.workbench.h"
#include "grts/structs.workbench.model.h"
#include "grts/structs.workbench.physical.h"

#endif

#endif

#endif // _STDAFX_H_
