/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __MODELVIEWFORM_H__
#define __MODELVIEWFORM_H__

#include "model/wb_model_diagram_form.h"
#include "GrtTemplates.h"

#ifdef _MSC_VER
using namespace MySQL::Grt;
using namespace MySQL::GUI::Mdc;
using namespace System;
using namespace System::Collections::Generic;
using namespace System::Windows::Forms;
#endif


namespace MySQL {
  namespace Workbench {

    public ref class ModelViewForm : public ::MySQL::Grt::UIForm
    {
      ::MySQL::Grt::GrtValueTree^ layer_tree;
      BaseWindowsCanvasView^ mini_view;

    public:

      ModelViewForm(::wb::ModelDiagramForm *inn)
        : ::MySQL::Grt::UIForm(inn), layer_tree(nullptr)
      { 
        
      }

      ~ModelViewForm()
      {
        //delete mini_view;
      }

      ::wb::ModelDiagramForm* get_unmanaged_object()
      {
        return (::wb::ModelDiagramForm*)inner;
      }
      

      void OnMouseMove(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
      {
        get_unmanaged_object()->handle_mouse_move(X, Y, 
          ::MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(keystate, buttons));
      }

      void OnMouseDown(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
      {
        mdc::MouseButton butt= mdc::ButtonLeft;
        switch(e->Button)
        {
        case MouseButtons::Left: butt= mdc::ButtonLeft; break;
        case MouseButtons::Middle: butt= mdc::ButtonMiddle; break;
        case MouseButtons::Right: butt= mdc::ButtonRight; break;
        }
        get_unmanaged_object()->handle_mouse_button(butt, true, X, Y, 
          ::MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(keystate, buttons));
      }

      void OnMouseUp(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
      {
        mdc::MouseButton butt= mdc::ButtonLeft;
        switch(e->Button)
        {
        case MouseButtons::Left: butt= mdc::ButtonLeft; break;
        case MouseButtons::Middle: butt= mdc::ButtonMiddle; break;
        case MouseButtons::Right: butt= mdc::ButtonRight; break;
        }
        get_unmanaged_object()->handle_mouse_button(butt, false, X, Y,
          ::MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(keystate, buttons));
      }

      void OnMouseDoubleClick(MouseEventArgs^ e, int X, int Y, Keys keystate, MouseButtons buttons)
      {
        mdc::MouseButton butt= mdc::ButtonLeft;
        switch(e->Button)
        {
        case MouseButtons::Left: butt= mdc::ButtonLeft; break;
        case MouseButtons::Middle: butt= mdc::ButtonMiddle; break;
        case MouseButtons::Right: butt= mdc::ButtonRight; break;
        }
        get_unmanaged_object()->handle_mouse_double_click(butt, X, Y,
          ::MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(keystate, buttons));
      }

      void OnKeyDown(KeyEventArgs^ e, Keys keystate)
      {
        if (get_unmanaged_object()->handle_key(::MySQL::GUI::Mdc::BaseWindowsCanvasView::getKeyInfo(e), true, 
          ::MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(keystate, MouseButtons::None)))
        {
          // If the keyboard input has been handled then tell the caller not to process this any further.
          e->SuppressKeyPress= true;
        }
      }

      void OnKeyUp(KeyEventArgs^ e, Keys keystate)
      {
        get_unmanaged_object()->handle_key(::MySQL::GUI::Mdc::BaseWindowsCanvasView::getKeyInfo(e), false, 
          ::MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(keystate, MouseButtons::None));
      }


      String^ get_tool_cursor()
      { return CppStringToNative(get_unmanaged_object()->get_cursor()); }
      
      bool accepts_drop(int x, int y, String^ type, List<GrtValue^>^ objects)
      {
        std::list<GrtObjectRef> cobjects;

        List<GrtValue^>::Enumerator^ e= objects->GetEnumerator();
        while (e->MoveNext())
        {
          if (e->Current->is_object_instance_of("GrtObject"))
            cobjects.push_back(GrtObjectRef::cast_from(e->Current->get_unmanaged_object()));
          else
            return false;
        }

        return get_unmanaged_object()->
          accepts_drop(x, y, NativeToCppString(type), cobjects);
      }

      bool accepts_drop(int x, int y, String^ type, String^ text)
      {
        return get_unmanaged_object()->
          accepts_drop(x, y, NativeToCppString(type), NativeToCppString(text));
      }

      bool perform_drop(int x, int y, String^ type, List<GrtValue^>^ objects)
      {
        std::list<GrtObjectRef> cobjects;

        List<GrtValue^>::Enumerator^ e= objects->GetEnumerator();
        while (e->MoveNext())
        {
          if (e->Current->is_object_instance_of("GrtObject"))
            cobjects.push_back(GrtObjectRef::cast_from(e->Current->get_unmanaged_object()));
          else
            return false;
        }

        return get_unmanaged_object()->
          perform_drop(x, y, NativeToCppString(type), cobjects);
      }

      bool perform_drop(int x, int y, String^ type, String^ text)
      {
        return get_unmanaged_object()->
          perform_drop(x, y, NativeToCppString(type), NativeToCppString(text));
      }

      void set_closed(bool flag)
      {
        if (get_unmanaged_object())
          get_unmanaged_object()->set_closed(flag);
      }

      bool is_closed()
      {
        if (get_unmanaged_object())
          return get_unmanaged_object()->is_closed();
        return false;
      }

      ::MySQL::Grt::GrtValueTree^ get_layer_tree()
      {
        if (layer_tree == nullptr)
          layer_tree= gcnew ::MySQL::Grt::GrtValueTree(get_unmanaged_object()->get_layer_tree());

        return layer_tree;
      } 

      void setup_mini_view(BaseWindowsCanvasView^ view)
      {
        mini_view= view;

        get_unmanaged_object()->setup_mini_view(mini_view->get_unmanaged_object());
      }

      void update_mini_view_size(int w, int h)
      {
        if (get_unmanaged_object() != NULL)
          get_unmanaged_object()->update_mini_view_size(w, h);
      }

      double get_zoom()
      {
        if (get_unmanaged_object() != NULL)
          return get_unmanaged_object()->get_zoom();

        return 1;
      }

      void set_zoom(double zoom)
      {
        if (get_unmanaged_object() != NULL)
          get_unmanaged_object()->set_zoom(zoom);
      }

      String^ get_title()
      {
        return CppStringToNative(get_unmanaged_object()->get_title());
      }
    };

  } // namespace Workbench
} // namespace MySQL

#endif // __MODELVIEWFORM_H__
