
#include "sqlide_form.h"
#include "workbench/wb_context_ui.h"
#include "linux_utilities/plugin_editor_base.h"
#include "sqlide_main.h"

class ToolbarManager;

static void close_plugin(PluginEditorBase *editor, wb::WBContext *wb)
{
  wb->close_gui_plugin(dynamic_cast<GUIPluginBase*>(editor));
}


static FormViewBase *create_db_sql_editor_view(boost::shared_ptr<bec::UIForm> form, wb::WBContext *wb)
{
  Db_sql_editor::Ref editor_be= Db_sql_editor::Ref(boost::dynamic_pointer_cast<Db_sql_editor>(form));
  
  DbSqlEditorView *view= Gtk::manage(new DbSqlEditorView(editor_be));
  
  view->set_close_editor_callback(sigc::bind(sigc::ptr_fun(close_plugin), wb));

  view->init();
  return view;
}



static DbSqlEditorView *get_current_editor(wb::WBContextUI *wbui)
{
  bec::UIForm *form= wbui->get_active_main_form();
  if (form)
    return dynamic_cast<DbSqlEditorView*>(reinterpret_cast<FormViewBase*>(form->get_frontend_data()));

  return 0;
}


static void call_execute(wb::WBContextUI *wbui)
{
  DbSqlEditorView *editor= get_current_editor(wbui);
  if (editor)
    editor->execute_sql_script(false);
}

static bool validate_execute(wb::WBContextUI *wbui)
{
  return get_current_editor(wbui) != 0;
}


static void call_execute_current_statement(wb::WBContextUI *wbui)
{
  DbSqlEditorView *editor= get_current_editor(wbui);
  if (editor)
    editor->execute_sql_script(true);
}

static bool validate_execute_current_statement(wb::WBContextUI *wbui)
{
  return get_current_editor(wbui) != 0;
}


static void call_save_edits(wb::WBContextUI *wbui)
{
  DbSqlEditorView *editor= get_current_editor(wbui);
  if (editor && editor->get_active_recordset())
    editor->get_active_recordset()->save_changes();
}

static bool validate_save_edits(wb::WBContextUI *wbui)
{
  DbSqlEditorView *editor= get_current_editor(wbui);
  if (editor && editor->get_active_recordset())
    return editor->get_active_recordset()->has_changes();
  return false;
}


static void call_discard_edits(wb::WBContextUI *wbui)
{
  DbSqlEditorView *editor= get_current_editor(wbui);
  if (editor && editor->get_active_recordset())
    get_current_editor(wbui)->get_active_recordset()->revert_changes();
}

static bool validate_discard_edits(wb::WBContextUI *wbui)
{
  DbSqlEditorView *editor= get_current_editor(wbui);
  if (editor && editor->get_active_recordset())
    return editor->get_active_recordset()->has_changes();
  return false;
}



void setup_sqlide(wb::WBContextUI *wbui,
                  std::string &name, sigc::slot<FormViewBase*, boost::shared_ptr<bec::UIForm> > &create_function)
{
  wbui->get_command_ui()->add_builtin_command("query.execute", sigc::bind(sigc::ptr_fun(call_execute), wbui),
                                              sigc::bind(sigc::ptr_fun(validate_execute), wbui));
  
  wbui->get_command_ui()->add_builtin_command("query.execute_current_statement", sigc::bind(sigc::ptr_fun(call_execute_current_statement), wbui),
                                              sigc::bind(sigc::ptr_fun(validate_execute_current_statement), wbui));

  wbui->get_command_ui()->add_builtin_command("query.save_edits", sigc::bind(sigc::ptr_fun(call_save_edits), wbui), 
                                              sigc::bind(sigc::ptr_fun(validate_save_edits), wbui));
  wbui->get_command_ui()->add_builtin_command("query.discard_edits", sigc::bind(sigc::ptr_fun(call_discard_edits), wbui), 
                                              sigc::bind(sigc::ptr_fun(validate_discard_edits), wbui));

  
  name= WB_MAIN_VIEW_DB_QUERY;
  create_function= sigc::bind(sigc::ptr_fun(create_db_sql_editor_view), wbui->get_wb());
}
