//
//  MOutlineView.m
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 24/May/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MOutlineView.h"

#import "GRTTreeDataSource.h"
#import "MCPPUtilities.h"

const NSString* NSMenuActionNotification = @"NSMenuActionNotification";

@interface NSObject ()
- (bec::TreeModel*)treeModelForOutlineView:(NSOutlineView*)outline;
@end


@implementation MOutlineView


static void refresh_tree(const bec::NodeId &node, int ocount, NSOutlineView *self)
{
  [self reloadData];
}


- (std::vector<bec::NodeId>)selectedNodeIds
{
  std::vector<bec::NodeId> nodes;
  NSIndexSet *iset= [self selectedRowIndexes];
  NSUInteger index = [iset firstIndex];
  while (index != NSNotFound)
  {
    nodes.push_back([[self itemAtRow: index] nodeId]);
    index = [iset indexGreaterThanIndex: index];
  }
  
  return nodes;
}


- (bec::TreeModel*)getTreeModel
{
  bec::TreeModel *model= 0;
  id dataSource= [self dataSource];
  
  // hack because of stupid implementation of DbMySQLTableEditor
  if ([dataSource respondsToSelector: @selector(treeModelForOutlineView:)])
    model= [dataSource treeModelForOutlineView: self];
  
  if ([dataSource respondsToSelector: @selector(treeModel)])
    model= [dataSource treeModel];
  
  return model;
}


- (void)reloadData
{
  [super reloadData];

  if (!mConnectedRefresh)
  {
    bec::TreeModel *model = [self getTreeModel];
    if (model)
      model->tree_changed_signal().connect(sigc::bind(sigc::ptr_fun(refresh_tree), self));
    mConnectedRefresh= YES;
  }
}


- (void)fillMenu:(NSMenu*)menu withItems:(const bec::MenuItemList&)items 
        selector:(SEL)selector
{
  for (bec::MenuItemList::const_iterator iter= items.begin(); iter != items.end(); ++iter)
  {
    if (iter->type == bec::MenuSeparator)
      [menu addItem: [NSMenuItem separatorItem]];
    else
    {
      SEL itemAction;
      if (iter->type == bec::MenuCascade)
      {
        itemAction = nil;
      }
      else
      {
        itemAction = @selector(activateMenuItem:);
      }
      
      NSMenuItem *item= [menu addItemWithTitle: [NSString stringWithCPPString: iter->caption]
                                          action: itemAction
                                   keyEquivalent: @""];
      [item setTarget: self];
      if (!iter->enabled)
        [item setEnabled: NO];
      [item setRepresentedObject: [NSString stringWithCPPString: iter->name]];
      
      if (iter->type == bec::MenuCascade)
      {
        if (!iter->subitems.empty())
        {
          NSMenu *submenu= [[[NSMenu alloc] initWithTitle: @""] autorelease];
          [self fillMenu: submenu withItems:iter->subitems selector:@selector(activateMenuItem:)];
          [item setSubmenu: submenu];
        }
      }
    }
  }
}


- (NSMenu *)menuForEvent:(NSEvent *)theEvent
{
  bec::TreeModel *model= [self getTreeModel];
  
  if (model)
  {      
    bec::MenuItemList items= model->get_popup_items_for_nodes([self selectedNodeIds]);
    NSMenu *menu= [[[NSMenu alloc] initWithTitle: @""] autorelease];
    if (!items.empty())
    {
      [self fillMenu: menu withItems:items selector:@selector(activateMenuItem:)];
      return menu;
    }
  }

  return [super menuForEvent: theEvent];
}


- (BOOL) canDeleteItem: (id)sender
{
  bec::TreeModel *model= [self getTreeModel];
  
  std::vector<bec::NodeId> nodes= [self selectedNodeIds];
  
  if (model && nodes.size() == 1)
    return model->can_delete_node(nodes.front());

  return NO;
}


- (void)rightMouseDown:(NSEvent *)theEvent
{
  [self selectRowIndexes: [NSIndexSet indexSetWithIndex: [self rowAtPoint: [self convertPointFromBase: [theEvent locationInWindow]]]]
    byExtendingSelection: NO];
  [super rightMouseDown: theEvent];
}


- (void) deleteItem: (id)sender
{
  bec::TreeModel *model= [self getTreeModel];
  
  std::vector<bec::NodeId> nodes= [self selectedNodeIds];
  
  if (model && nodes.size() == 1)
  {
    if (model->delete_node(nodes.front()))
      [self noteNumberOfRowsChanged];
  }
}


- (void)activateMenuItem:(id)sender
{
  bec::TreeModel *model= [self getTreeModel];
  if (model)
  {
    if (model->activate_popup_item_for_nodes([[sender representedObject] UTF8String], 
                                            [self selectedNodeIds]))
      ;
      //[self reloadData];
    else
      [[NSNotificationCenter defaultCenter] postNotificationName: NSMenuActionNotification object: sender];
  }
}

@end
