//
//  NSString_extras.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 4/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "NSString_extras.h"

@implementation NSString(CPPExtras)

//--------------------------------------------------------------------------------------------------

+ (NSString*)stringWithCPPString:(const std::string&) str
{
  NSString* result = [[[NSString alloc] initWithBytes: str.data() length: str.length() encoding: NSUTF8StringEncoding] autorelease];
  
  // If the input string is not encoded in UTF-8 it might contain byte sequences
  // which can make up a wrong code if interpreted as UTF-8 and the above conversion fails.
  // In this case try again and initialize as normal ANSI (Latin 1) encoding.
  // This is quite a guessing game, but the price for using code pages in files.
  if (result == nil)
    result= [[[NSString alloc] initWithBytes: str.data() length: str.length() encoding: NSISOLatin1StringEncoding] autorelease];

  return result;
}

//--------------------------------------------------------------------------------------------------

/**
 * Compares this string with another case-insensitvely and returns true if they are the same.
 */
- (BOOL) isSameAs: (NSString*) other
{
  return ([self caseInsensitiveCompare: other] == NSOrderedSame);
}

//--------------------------------------------------------------------------------------------------

@end
