//
//  WBPluginPanel.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 17/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "WBPluginPanel.h"
#include "grt/grt_manager.h"

@implementation WBPluginPanel

- (id)initWithPlugin:(WBPluginEditorBase*)plugin
{
  self= [super init];
  if (self)
  {
    mPluginEditor= [plugin retain];
  }
  return self;
}

- (void) dealloc
{
  [mPluginEditor grtManager]->get_plugin_manager()->forget_gui_plugin_handle(self);
  
  [mPluginEditor release];
  [super dealloc];
}


- (WBPluginEditorBase*)pluginEditor
{
  return mPluginEditor;
}


- (NSView*)topView
{
  return [mPluginEditor dockableView];
}

- (NSString*)title
{
  return [mPluginEditor title];
}

- (NSString*)identifier
{
  return [mPluginEditor identifier];
}

- (NSImage*)tabIcon
{
  return [mPluginEditor titleIcon];
}

- (bec::UIForm*)formBE
{
  return 0;
}


- (NSSize)minimumSize
{
  return [mPluginEditor minimumSize];
}


- (BOOL)willClose
{
  if ([mPluginEditor respondsToSelector:@selector(pluginWillClose:)])
    return [mPluginEditor pluginWillClose:self];
  return YES;
}

@end
