//
//  WBSQLQueryUI.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 28/Apr/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//


#import "WBSQLQueryPanel.h"

#import "WBMainController.h"
#import "WBMainWindow.h"
#import "MResultsetViewer.h"

#include "workbench/wb_context_ui.h"

#import "WBSQLQueryUI.h"


static WBSQLQueryPanel *getQueryPanel(wb::WBContextUI *wbui)
{
  bec::UIForm *form= wbui->get_active_main_form();
  if (form)
  {
    id panel= (id)form->get_frontend_data();
    if (panel)
    {
      if ([panel isKindOfClass: [WBSQLQueryPanel class]])
        return (WBSQLQueryPanel*)panel;
    }
  }
  return nil;
}

static void call_execute(wb::WBContextUI *wbui)
{
  [getQueryPanel(wbui) executeQuery:nil currentStatementOnly:false];
}

static bool validate_query_panel_active(wb::WBContextUI *wbui)
{
  return getQueryPanel(wbui) != nil;
}


static void call_execute_current_statement(wb::WBContextUI *wbui)
{
  [getQueryPanel(wbui) executeQuery:nil currentStatementOnly:true];
}

static bool validate_execute_current_statement(wb::WBContextUI *wbui)
{
  return getQueryPanel(wbui) != nil;
}


static void call_save_edits(wb::WBContextUI *wbui)
{
  [[getQueryPanel(wbui) selectedResultset] saveEdits: nil];
}

static bool validate_save_edits(wb::WBContextUI *wbui)
{
  return [[getQueryPanel(wbui) selectedResultset] hasPendingChanges];
}


static void call_discard_edits(wb::WBContextUI *wbui)
{
  [[getQueryPanel(wbui) selectedResultset] discardEdits:nil];  
}

static bool validate_discard_edits(wb::WBContextUI *wbui)
{
  return [[getQueryPanel(wbui) selectedResultset] hasPendingChanges];
}


static WBBasePanel *createQueryPanel(WBMainWindow *mainwin, boost::shared_ptr<bec::UIForm> form)
{
  Db_sql_editor::Ref editor= boost::dynamic_pointer_cast<Db_sql_editor>(form);
  
  if (!editor)
    throw std::logic_error("invalid backend object");

  WBSQLQueryPanel *panel= [[[WBSQLQueryPanel alloc] initWithBE: editor] autorelease];
  [panel setRightSidebar: [mainwin context]->get_wb()->get_wb_options().get_int("Sidebar:RightAligned", 0)];
  return panel;
}


void setupSQLQueryUI(WBMainController *main, WBMainWindow *mainwin, wb::WBContextUI *wbui)
{  
  wbui->get_command_ui()->add_builtin_command("query.execute", sigc::bind(sigc::ptr_fun(call_execute), wbui), 
                                              sigc::bind(sigc::ptr_fun(validate_query_panel_active), wbui));
  wbui->get_command_ui()->add_builtin_command("query.execute_current_statement", sigc::bind(sigc::ptr_fun(call_execute_current_statement), wbui), 
                                              sigc::bind(sigc::ptr_fun(validate_execute_current_statement), wbui));

  wbui->get_command_ui()->add_builtin_command("query.save_edits", sigc::bind(sigc::ptr_fun(call_save_edits), wbui), 
                                              sigc::bind(sigc::ptr_fun(validate_save_edits), wbui));
  wbui->get_command_ui()->add_builtin_command("query.discard_edits", sigc::bind(sigc::ptr_fun(call_discard_edits), wbui), 
                                              sigc::bind(sigc::ptr_fun(validate_discard_edits), wbui));
  
  // other commands in wb_context_sqlide.cpp

  [main registerFormPanelFactory:createQueryPanel forFormType: WB_MAIN_VIEW_DB_QUERY];
}

