using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;

namespace MySQL.Utilities
{
  public class DrawablePanel : Panel
  {
    private bool customBackground = false;

    public DrawablePanel()
    {
      DoubleBuffered = true;
    }

    public bool CustomBackground
    {
      get { return customBackground; }
      set { customBackground = value; }
    }

    protected override void OnPaintBackground(PaintEventArgs e)
    {
      if (!customBackground)
        base.OnPaintBackground(e);
    }
  }
}
