using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MySQL.Workbench;
using MySQL.GUI.Workbench.Properties;
using MySQL.GUI.Mdc;
using MySQL.Grt;
using System.Drawing.Drawing2D;
using MySQL.Controls;


namespace MySQL.GUI.Workbench
{
  public partial class SqlSnippetsForm : Form
  {
    private WbContext wbContext;
    public SimpleGrtListModel SqlSnippetsModel;
    private ScintillaNet.Scintilla editor;

    private bool activate_item(String name)
    {
      NodeId node;
      if (sqlSnippetsTreeView.SelectedNode != null)
        node = new NodeId(sqlSnippetsTreeView.SelectedNode.Index);
      else
        node = new NodeId();
      return DbSqlEditorSnippets.get_instance().activate_toolbar_item(node, name);
    }

    public SqlSnippetsForm(WbContext WbContext)
    {
      wbContext = WbContext;
      InitializeComponent();

      ToolStripItem item1 = toolStrip1.Items[0];
      ToolStripItem item2 = toolStrip1.Items[1];

      WorkbenchToolbarManager.get_instance().UpdateToolbar(toolStrip1,
        DbSqlEditorSnippets.get_instance().get_toolbar_items(),
        activate_item);

      toolStrip1.Items.Add(item1);
      toolStrip1.Items.Add(item2);
      toolStrip1.Renderer = new FlatSubToolStripRenderer();

      nodeTextBox1.DrawText += new EventHandler<Aga.Controls.Tree.NodeControls.DrawEventArgs>(nodeTextBox1_DrawText);

      sqlSnippetsTreeView.SelectionChanged += new EventHandler(sqlSnippetsTreeView_SelectionChanged);
      collectionCombo.SelectedIndexChanged += new EventHandler(collectionCombo_SelectedIndexChanged);

      editor = new ScintillaNet.Scintilla();
      splitContainer1.Panel2.Controls.Add(editor);
      editor.Margins.Margin0.Width = 0; // line numbers
      editor.Margins.Margin1.Width = 0; // markers
      editor.Margins.Margin2.Width = 0; // indicators
      editor.ConfigurationManager.Language = "mysql";
      editor.NativeInterface.SetCodePage((int)ScintillaNet.Constants.SC_CP_UTF8);
      editor.NativeInterface.SetReadOnly(true);
      editor.Dock = DockStyle.Fill;

      collectionCombo.Items.AddRange(DbSqlEditorSnippets.get_instance().get_category_list().ToArray());
      collectionCombo.SelectedIndex = 0;
    }

    void nodeTextBox1_DrawText(object sender, Aga.Controls.Tree.NodeControls.DrawEventArgs e)
    {
      // This handler has been registered for the first column so we can make a few assumptions.
      using (Brush brush = new SolidBrush(Color.FromArgb(71, 100, 144)))
      {
        e.Context.Graphics.SmoothingMode = SmoothingMode.HighQuality;
        RectangleF bounds = new Rectangle(7, e.Context.Bounds.Y + (e.Context.Bounds.Height - 17) / 2, 17, 17);
        e.Context.Graphics.FillEllipse(brush, bounds);

        bounds.X += 0.5f;
        bounds.Y += 0.5f;
        e.TextColor = Color.White;
        StringFormat format = new StringFormat();
        format.Alignment = StringAlignment.Center;
        format.LineAlignment = StringAlignment.Center;
        e.Context.Graphics.DrawString(e.Text, e.Font, Brushes.White, bounds, format);

        e.TextColor = Color.Transparent;
      }    
    }

    void collectionCombo_SelectedIndexChanged(object sender, EventArgs e)
    {
      // Load the snippets list for this collection category.
      DbSqlEditorSnippets.get_instance().select_category(collectionCombo.Items[collectionCombo.SelectedIndex].ToString());

      // Select the first node in the snippets tree and hence initialize the editor.
      if (sqlSnippetsTreeView.Root.Children.Count == 0)
        sqlSnippetsTreeView.SelectedNode = null;
      else
        sqlSnippetsTreeView.SelectedNode = sqlSnippetsTreeView.Root.Children[0];
    }

    void sqlSnippetsTreeView_SelectionChanged(object sender, EventArgs e)
    {
      if (sqlSnippetsTreeView.SelectedNode != null)
      {
        NodeId node = new NodeId(sqlSnippetsTreeView.SelectedNode.Index);
        String text;

        DbSqlEditorSnippets.get_instance().get_field(node, 2, out text);
        editor.NativeInterface.SetReadOnly(false);
        editor.Text = text;
        editor.NativeInterface.SetReadOnly(true);
      }
      else
        editor.Text = "";
    }

    public void Init()
    {
      if (null == SqlSnippetsModel)
      {
        SqlSnippetsModel = new SimpleGrtListModel(sqlSnippetsTreeView, DbSqlEditorSnippets.get_instance(), true);
        SqlSnippetsModel.AddColumn(nodeTextBox1, 0, false);
        SqlSnippetsModel.AddColumn(nodeTextBox2, 1, false);
        sqlSnippetsTreeView.Model = SqlSnippetsModel;
      }
    }

    private void sqlSnippetsTreeView_NodeMouseDoubleClick(object sender, Aga.Controls.Tree.TreeNodeAdvMouseEventArgs e)
    {
      SqlSnippetsModel.GrtList.activate_node(new NodeId(sqlSnippetsTreeView.CurrentNode.Index));
    }
  }
}
