using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using MySQL.Grt;
using MySQL.Utilities;
using MySQL.Workbench;

namespace MySQL.GUI.Workbench
{
  class WorkbenchMenuManager : MenuManager
  {
    #region Member Variables
    
    // The Workbench context
    private WbContext wbContext;

    #endregion

    #region Constructors

    public WorkbenchMenuManager(WbContext WbContext)
    {
      wbContext = WbContext;
    }

    #endregion

    public void RefreshMainEditMenu(System.Windows.Forms.MenuStrip menuStrip)
    {
      foreach (System.Windows.Forms.ToolStripMenuItem item in menuStrip.Items)
      {
        if (item.Name == "edit")
        {
          buildSubmenu(item, "edit", wbContext.get_items_for_menu("edit"), new EventHandler(menuItem_Click));
          break;
        }
      }
    }

    public void ConstructMainMenu(System.Windows.Forms.MenuStrip menuStrip)
    {
      List<MySQL.Grt.MenuItem> items = wbContext.get_main_menus();

      menuStrip.Items.Clear();

      foreach (MySQL.Grt.MenuItem item in items)
      {
        System.Windows.Forms.ToolStripMenuItem tsitem;

        tsitem = new System.Windows.Forms.ToolStripMenuItem();
        tsitem.Name = item.get_name();
        tsitem.Text = item.get_caption();

        if (item.get_name() == "edit")
          tsitem.DropDownOpening += new EventHandler(tsitem_DropDownOpening);
        buildSubmenu(tsitem, item.get_name(), item.get_subitems(), new EventHandler(menuItem_Click));

        menuStrip.Items.Add(tsitem);
      }
    }

    void tsitem_DropDownOpening(object sender, EventArgs e)
    {
      System.Windows.Forms.ToolStripMenuItem tsitem = sender as ToolStripMenuItem;

      buildSubmenu(tsitem, tsitem.Name, null, new EventHandler(menuItem_Click));
    }

    public override void buildSubmenu(ToolStripMenuItem parentItem, String name, List<MySQL.Grt.MenuItem> subitems, EventHandler handler)
    {
      if (subitems == null || subitems.Count == 0)
        subitems = wbContext.get_items_for_menu(name);
      base.buildSubmenu(parentItem, name, subitems, handler);
    }

    public System.Windows.Forms.ContextMenuStrip ShowContextMenu(System.Windows.Forms.Control parent, List<MySQL.Grt.MenuItem> items, int x, int y)
    {
      System.Windows.Forms.ContextMenuStrip menu = new System.Windows.Forms.ContextMenuStrip();
      System.Windows.Forms.ToolStripItem[] itemList;

      itemList = buildMenu(items, new EventHandler(menuItem_Click));
      menu.Items.AddRange(itemList);

      menu.Show(parent, new System.Drawing.Point(x, y), ToolStripDropDownDirection.BelowRight);

      return menu;
    }

    void menuItem_Click(object sender, EventArgs e)
    {
      System.Windows.Forms.ToolStripMenuItem item = sender as System.Windows.Forms.ToolStripMenuItem;

      if (item != null)
      {
        wbContext.activate_command(item.Name);
      }
    }
  }
}
