#ifndef __grts_structs_db_maxdb_h__
#define __grts_structs_db_maxdb_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_DB_MAXDB_EXPORT
  #define GRT_STRUCTS_DB_MAXDB_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_DB_MAXDB_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_DB_MAXDB_PUBLIC
#endif

#include <grts/structs.db.h>


class db_maxdb_Sequence;
typedef grt::Ref<db_maxdb_Sequence> db_maxdb_SequenceRef;
class db_maxdb_Synonym;
typedef grt::Ref<db_maxdb_Synonym> db_maxdb_SynonymRef;
class db_maxdb_Routine;
typedef grt::Ref<db_maxdb_Routine> db_maxdb_RoutineRef;
class db_maxdb_RoutineGroup;
typedef grt::Ref<db_maxdb_RoutineGroup> db_maxdb_RoutineGroupRef;
class db_maxdb_View;
typedef grt::Ref<db_maxdb_View> db_maxdb_ViewRef;
class db_maxdb_Trigger;
typedef grt::Ref<db_maxdb_Trigger> db_maxdb_TriggerRef;
class db_maxdb_ForeignKey;
typedef grt::Ref<db_maxdb_ForeignKey> db_maxdb_ForeignKeyRef;
class db_maxdb_IndexColumn;
typedef grt::Ref<db_maxdb_IndexColumn> db_maxdb_IndexColumnRef;
class db_maxdb_Index;
typedef grt::Ref<db_maxdb_Index> db_maxdb_IndexRef;
class db_maxdb_StructuredDatatype;
typedef grt::Ref<db_maxdb_StructuredDatatype> db_maxdb_StructuredDatatypeRef;
class db_maxdb_SimpleDatatype;
typedef grt::Ref<db_maxdb_SimpleDatatype> db_maxdb_SimpleDatatypeRef;
class db_maxdb_Column;
typedef grt::Ref<db_maxdb_Column> db_maxdb_ColumnRef;
class db_maxdb_Table;
typedef grt::Ref<db_maxdb_Table> db_maxdb_TableRef;
class db_maxdb_Schema;
typedef grt::Ref<db_maxdb_Schema> db_maxdb_SchemaRef;
class db_maxdb_Catalog;
typedef grt::Ref<db_maxdb_Catalog> db_maxdb_CatalogRef;


  /** a MaxDB database sequence object */
class  db_maxdb_Sequence : public db_Sequence
{
  typedef db_Sequence super;
public:
  db_maxdb_Sequence(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Sequence(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _createTime("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.Sequence"; }

  /** Getter for attribute comment
   
    
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

protected:

  grt::StringRef _createTime;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Sequence(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Sequence::create);
    {
      void (db_maxdb_Sequence::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Sequence::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Sequence::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Sequence::*getter)() const= 0;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Sequence::*setter)(const grt::StringRef &)= &db_maxdb_Sequence::createTime;
      grt::StringRef (db_maxdb_Sequence::*getter)() const= &db_maxdb_Sequence::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Sequence,grt::StringRef >(getter,setter));
    }
  }
};


  /** a MaxDB database synonym object */
class  db_maxdb_Synonym : public db_Synonym
{
  typedef db_Synonym super;
public:
  db_maxdb_Synonym(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Synonym(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _createTime("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.Synonym"; }

  /** Getter for attribute comment
   
    
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

protected:

  grt::StringRef _createTime;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Synonym(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Synonym::create);
    {
      void (db_maxdb_Synonym::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Synonym::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_Synonym,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Synonym::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Synonym::*getter)() const= 0;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Synonym,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Synonym::*setter)(const grt::StringRef &)= &db_maxdb_Synonym::createTime;
      grt::StringRef (db_maxdb_Synonym::*getter)() const= &db_maxdb_Synonym::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Synonym,grt::StringRef >(getter,setter));
    }
  }
};


  /** a MaxDB Stored Procedure or Stored Function */
class  db_maxdb_Routine : public db_Routine
{
  typedef db_Routine super;
public:
  db_maxdb_Routine(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Routine(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _createTime("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.Routine"; }

  /** Getter for attribute comment
   
    
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

protected:

  grt::StringRef _createTime;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Routine(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Routine::create);
    {
      void (db_maxdb_Routine::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Routine::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_Routine,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Routine::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Routine::*getter)() const= 0;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Routine,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Routine::*setter)(const grt::StringRef &)= &db_maxdb_Routine::createTime;
      grt::StringRef (db_maxdb_Routine::*getter)() const= &db_maxdb_Routine::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Routine,grt::StringRef >(getter,setter));
    }
  }
};


  /** a MaxDB routine group */
class  db_maxdb_RoutineGroup : public db_RoutineGroup
{
  typedef db_RoutineGroup super;
public:
  db_maxdb_RoutineGroup(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_RoutineGroup(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "db.maxdb.RoutineGroup"; }

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_RoutineGroup(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_RoutineGroup::create);
  }
};


class  db_maxdb_View : public db_View
{
  typedef db_View super;
public:
  db_maxdb_View(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_View(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _alterDate(""),
     _alterTime(""),
     _createTime(""),
     _privileges(""),
     _unloaded(""),
     _updStatDate(""),
     _updStatTime("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.View"; }

  /** Getter for attribute alterDate
   
    Change date of view table
   \par In Python:
value = obj.alterDate
   */
  grt::StringRef alterDate() const { return _alterDate; }
  /** Setter for attribute alterDate
   
    Change date of view table
    \par In Python:
obj.alterDate = value
   */
  virtual void alterDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_alterDate);
   _alterDate= value;
    member_changed("alterDate", ovalue, value);
  }

  /** Getter for attribute alterTime
   
    Change time of view table
   \par In Python:
value = obj.alterTime
   */
  grt::StringRef alterTime() const { return _alterTime; }
  /** Setter for attribute alterTime
   
    Change time of view table
    \par In Python:
obj.alterTime = value
   */
  virtual void alterTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_alterTime);
   _alterTime= value;
    member_changed("alterTime", ovalue, value);
  }

  /** Getter for attribute comment
   
    
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

  /** Getter for attribute privileges
   
    Privileges of user for view table
   \par In Python:
value = obj.privileges
   */
  grt::StringRef privileges() const { return _privileges; }
  /** Setter for attribute privileges
   
    Privileges of user for view table
    \par In Python:
obj.privileges = value
   */
  virtual void privileges(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_privileges);
   _privileges= value;
    member_changed("privileges", ovalue, value);
  }

  /** Getter for attribute unloaded
   
    View table is unloaded (YES | NO)
   \par In Python:
value = obj.unloaded
   */
  grt::StringRef unloaded() const { return _unloaded; }
  /** Setter for attribute unloaded
   
    View table is unloaded (YES | NO)
    \par In Python:
obj.unloaded = value
   */
  virtual void unloaded(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_unloaded);
   _unloaded= value;
    member_changed("unloaded", ovalue, value);
  }

  /** Getter for attribute updStatDate
   
    Date of last UPDATE STATISTICS statement for view table
   \par In Python:
value = obj.updStatDate
   */
  grt::StringRef updStatDate() const { return _updStatDate; }
  /** Setter for attribute updStatDate
   
    Date of last UPDATE STATISTICS statement for view table
    \par In Python:
obj.updStatDate = value
   */
  virtual void updStatDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_updStatDate);
   _updStatDate= value;
    member_changed("updStatDate", ovalue, value);
  }

  /** Getter for attribute updStatTime
   
    Time of last UPDATE STATISTICS statement for view table
   \par In Python:
value = obj.updStatTime
   */
  grt::StringRef updStatTime() const { return _updStatTime; }
  /** Setter for attribute updStatTime
   
    Time of last UPDATE STATISTICS statement for view table
    \par In Python:
obj.updStatTime = value
   */
  virtual void updStatTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_updStatTime);
   _updStatTime= value;
    member_changed("updStatTime", ovalue, value);
  }

protected:

  grt::StringRef _alterDate;
  grt::StringRef _alterTime;
  grt::StringRef _createTime;
  grt::StringRef _privileges;
  grt::StringRef _unloaded;
  grt::StringRef _updStatDate;
  grt::StringRef _updStatTime;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_View(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_View::create);
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::alterDate;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::alterDate;
      meta->bind_member("alterDate", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::alterTime;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::alterTime;
      meta->bind_member("alterTime", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_View::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_View::*getter)() const= 0;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::createTime;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::privileges;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::privileges;
      meta->bind_member("privileges", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::unloaded;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::unloaded;
      meta->bind_member("unloaded", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::updStatDate;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::updStatDate;
      meta->bind_member("updStatDate", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_View::*setter)(const grt::StringRef &)= &db_maxdb_View::updStatTime;
      grt::StringRef (db_maxdb_View::*getter)() const= &db_maxdb_View::updStatTime;
      meta->bind_member("updStatTime", new grt::MetaClass::Property<db_maxdb_View,grt::StringRef >(getter,setter));
    }
  }
};


class  db_maxdb_Trigger : public db_Trigger
{
  typedef db_Trigger super;
public:
  db_maxdb_Trigger(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Trigger(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _createTime(""),
     _definition("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.Trigger"; }

  /** Getter for attribute comment
   
    
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

  /** Getter for attribute definition
   
    SQL definition
   \par In Python:
value = obj.definition
   */
  grt::StringRef definition() const { return _definition; }
  /** Setter for attribute definition
   
    SQL definition
    \par In Python:
obj.definition = value
   */
  virtual void definition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_definition);
   _definition= value;
    member_changed("definition", ovalue, value);
  }

protected:

  grt::StringRef _createTime;
  grt::StringRef _definition;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Trigger(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Trigger::create);
    {
      void (db_maxdb_Trigger::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Trigger::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Trigger::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Trigger::*getter)() const= 0;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Trigger::*setter)(const grt::StringRef &)= &db_maxdb_Trigger::createTime;
      grt::StringRef (db_maxdb_Trigger::*getter)() const= &db_maxdb_Trigger::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Trigger::*setter)(const grt::StringRef &)= &db_maxdb_Trigger::definition;
      grt::StringRef (db_maxdb_Trigger::*getter)() const= &db_maxdb_Trigger::definition;
      meta->bind_member("definition", new grt::MetaClass::Property<db_maxdb_Trigger,grt::StringRef >(getter,setter));
    }
  }
};


class  db_maxdb_ForeignKey : public db_ForeignKey
{
  typedef db_ForeignKey super;
public:
  db_maxdb_ForeignKey(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_ForeignKey(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _createDate(""),
     _createTime("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.ForeignKey"; }

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  grt::StringRef createDate() const { return _createDate; }
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */
  virtual void createDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createDate);
   _createDate= value;
    member_changed("createDate", ovalue, value);
  }

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

protected:

  grt::StringRef _createDate;
  grt::StringRef _createTime;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_ForeignKey(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_ForeignKey::create);
    {
      void (db_maxdb_ForeignKey::*setter)(const grt::StringRef &)= &db_maxdb_ForeignKey::createDate;
      grt::StringRef (db_maxdb_ForeignKey::*getter)() const= &db_maxdb_ForeignKey::createDate;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_ForeignKey,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_ForeignKey::*setter)(const grt::StringRef &)= &db_maxdb_ForeignKey::createTime;
      grt::StringRef (db_maxdb_ForeignKey::*getter)() const= &db_maxdb_ForeignKey::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_ForeignKey,grt::StringRef >(getter,setter));
    }
  }
};


class  db_maxdb_IndexColumn : public db_IndexColumn
{
  typedef db_IndexColumn super;
public:
  db_maxdb_IndexColumn(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_IndexColumn(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _createDate(""),
     _createTime(""),
     _fileid(""),
     _filestate("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.IndexColumn"; }

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  grt::StringRef createDate() const { return _createDate; }
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */
  virtual void createDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createDate);
   _createDate= value;
    member_changed("createDate", ovalue, value);
  }

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

  /** Getter for attribute fileid
   
    
   \par In Python:
value = obj.fileid
   */
  grt::StringRef fileid() const { return _fileid; }
  /** Setter for attribute fileid
   
    
    \par In Python:
obj.fileid = value
   */
  virtual void fileid(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_fileid);
   _fileid= value;
    member_changed("fileid", ovalue, value);
  }

  /** Getter for attribute filestate
   
    
   \par In Python:
value = obj.filestate
   */
  grt::StringRef filestate() const { return _filestate; }
  /** Setter for attribute filestate
   
    
    \par In Python:
obj.filestate = value
   */
  virtual void filestate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_filestate);
   _filestate= value;
    member_changed("filestate", ovalue, value);
  }

protected:

  grt::StringRef _createDate;
  grt::StringRef _createTime;
  grt::StringRef _fileid;
  grt::StringRef _filestate;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_IndexColumn(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_IndexColumn::create);
    {
      void (db_maxdb_IndexColumn::*setter)(const grt::StringRef &)= &db_maxdb_IndexColumn::createDate;
      grt::StringRef (db_maxdb_IndexColumn::*getter)() const= &db_maxdb_IndexColumn::createDate;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_IndexColumn,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_IndexColumn::*setter)(const grt::StringRef &)= &db_maxdb_IndexColumn::createTime;
      grt::StringRef (db_maxdb_IndexColumn::*getter)() const= &db_maxdb_IndexColumn::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_IndexColumn,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_IndexColumn::*setter)(const grt::StringRef &)= &db_maxdb_IndexColumn::fileid;
      grt::StringRef (db_maxdb_IndexColumn::*getter)() const= &db_maxdb_IndexColumn::fileid;
      meta->bind_member("fileid", new grt::MetaClass::Property<db_maxdb_IndexColumn,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_IndexColumn::*setter)(const grt::StringRef &)= &db_maxdb_IndexColumn::filestate;
      grt::StringRef (db_maxdb_IndexColumn::*getter)() const= &db_maxdb_IndexColumn::filestate;
      meta->bind_member("filestate", new grt::MetaClass::Property<db_maxdb_IndexColumn,grt::StringRef >(getter,setter));
    }
  }
};


class  db_maxdb_Index : public db_Index
{
  typedef db_Index super;
public:
  db_maxdb_Index(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Index(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _averageSkLength(0),
     _avgNumPkPerList(0),
     _avgSeperatorLength(0),
     _createDate(""),
     _createTime(""),
     _disabled(0),
     _fileid(""),
     _filestate(""),
     _filetype(""),
     _indexLevels(0),
     _indexPageSpaceMax(0),
     _indexPageSpaceMin(0),
     _indexPages(0),
     _indexPagesSpace(0),
     _indexUsed(0),
     _leafPages(0),
     _leafPagesSpace(0),
     _leafPagesSpaceMax(0),
     _leafPagesSpaceMin(0),
     _maxNumPkPerList(0),
     _maxSeperatorLength(0),
     _maxSkLength(0),
     _minNumPkPerList(0),
     _minSeperatorLength(0),
     _minSkLength(0),
     _numDistinctValues(0),
     _numRowsPk(0),
     _rootPage(0),
     _rootPageSpace(0),
     _selectivityGreater25Percent(0),
     _selectivityLess10Percent(0),
     _selectivityLess1Percent(0),
     _selectivityLess25Percent(0),
     _selectivityLess5Percent(0),
     _totalSpaceUsed(0),
     _usedPages(0)

  {
  }

  static std::string static_class_name() { return "db.maxdb.Index"; }

  /** Getter for attribute averageSkLength
   
    Contains the average length of an index value
   \par In Python:
value = obj.averageSkLength
   */
  grt::IntegerRef averageSkLength() const { return _averageSkLength; }
  /** Setter for attribute averageSkLength
   
    Contains the average length of an index value
    \par In Python:
obj.averageSkLength = value
   */
  virtual void averageSkLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_averageSkLength);
   _averageSkLength= value;
    member_changed("averageSkLength", ovalue, value);
  }

  /** Getter for attribute avgNumPkPerList
   
    Primary key: contains the average number of keys for each invert list
   \par In Python:
value = obj.avgNumPkPerList
   */
  grt::IntegerRef avgNumPkPerList() const { return _avgNumPkPerList; }
  /** Setter for attribute avgNumPkPerList
   
    Primary key: contains the average number of keys for each invert list
    \par In Python:
obj.avgNumPkPerList = value
   */
  virtual void avgNumPkPerList(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_avgNumPkPerList);
   _avgNumPkPerList= value;
    member_changed("avgNumPkPerList", ovalue, value);
  }

  /** Getter for attribute avgSeperatorLength
   
    
   \par In Python:
value = obj.avgSeperatorLength
   */
  grt::IntegerRef avgSeperatorLength() const { return _avgSeperatorLength; }
  /** Setter for attribute avgSeperatorLength
   
    
    \par In Python:
obj.avgSeperatorLength = value
   */
  virtual void avgSeperatorLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_avgSeperatorLength);
   _avgSeperatorLength= value;
    member_changed("avgSeperatorLength", ovalue, value);
  }

  /** Getter for attribute comment
   
    
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  grt::StringRef createDate() const { return _createDate; }
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */
  virtual void createDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createDate);
   _createDate= value;
    member_changed("createDate", ovalue, value);
  }

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

  /** Getter for attribute disabled
   
    
   \par In Python:
value = obj.disabled
   */
  grt::IntegerRef disabled() const { return _disabled; }
  /** Setter for attribute disabled
   
    
    \par In Python:
obj.disabled = value
   */
  virtual void disabled(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_disabled);
   _disabled= value;
    member_changed("disabled", ovalue, value);
  }

  /** Getter for attribute fileid
   
    
   \par In Python:
value = obj.fileid
   */
  grt::StringRef fileid() const { return _fileid; }
  /** Setter for attribute fileid
   
    
    \par In Python:
obj.fileid = value
   */
  virtual void fileid(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_fileid);
   _fileid= value;
    member_changed("fileid", ovalue, value);
  }

  /** Getter for attribute filestate
   
    
   \par In Python:
value = obj.filestate
   */
  grt::StringRef filestate() const { return _filestate; }
  /** Setter for attribute filestate
   
    
    \par In Python:
obj.filestate = value
   */
  virtual void filestate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_filestate);
   _filestate= value;
    member_changed("filestate", ovalue, value);
  }

  /** Getter for attribute filetype
   
    Type of the B* tree
   \par In Python:
value = obj.filetype
   */
  grt::StringRef filetype() const { return _filetype; }
  /** Setter for attribute filetype
   
    Type of the B* tree
    \par In Python:
obj.filetype = value
   */
  virtual void filetype(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_filetype);
   _filetype= value;
    member_changed("filetype", ovalue, value);
  }

  /** Getter for attribute indexLevels
   
    Number of index levels in the B* tree
   \par In Python:
value = obj.indexLevels
   */
  grt::IntegerRef indexLevels() const { return _indexLevels; }
  /** Setter for attribute indexLevels
   
    Number of index levels in the B* tree
    \par In Python:
obj.indexLevels = value
   */
  virtual void indexLevels(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_indexLevels);
   _indexLevels= value;
    member_changed("indexLevels", ovalue, value);
  }

  /** Getter for attribute indexPageSpaceMax
   
    Contains the maximum used space of the index pages in the B* tree (as a percentage)
   \par In Python:
value = obj.indexPageSpaceMax
   */
  grt::IntegerRef indexPageSpaceMax() const { return _indexPageSpaceMax; }
  /** Setter for attribute indexPageSpaceMax
   
    Contains the maximum used space of the index pages in the B* tree (as a percentage)
    \par In Python:
obj.indexPageSpaceMax = value
   */
  virtual void indexPageSpaceMax(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_indexPageSpaceMax);
   _indexPageSpaceMax= value;
    member_changed("indexPageSpaceMax", ovalue, value);
  }

  /** Getter for attribute indexPageSpaceMin
   
    Contains the minimum used space of the index pages in the B* tree (as a percentage)
   \par In Python:
value = obj.indexPageSpaceMin
   */
  grt::IntegerRef indexPageSpaceMin() const { return _indexPageSpaceMin; }
  /** Setter for attribute indexPageSpaceMin
   
    Contains the minimum used space of the index pages in the B* tree (as a percentage)
    \par In Python:
obj.indexPageSpaceMin = value
   */
  virtual void indexPageSpaceMin(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_indexPageSpaceMin);
   _indexPageSpaceMin= value;
    member_changed("indexPageSpaceMin", ovalue, value);
  }

  /** Getter for attribute indexPages
   
    Indicates how many pages are used by the index in the B* tree index
   \par In Python:
value = obj.indexPages
   */
  grt::IntegerRef indexPages() const { return _indexPages; }
  /** Setter for attribute indexPages
   
    Indicates how many pages are used by the index in the B* tree index
    \par In Python:
obj.indexPages = value
   */
  virtual void indexPages(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_indexPages);
   _indexPages= value;
    member_changed("indexPages", ovalue, value);
  }

  /** Getter for attribute indexPagesSpace
   
    Space used of the index pages in the B* tree (as a percentage)
   \par In Python:
value = obj.indexPagesSpace
   */
  grt::IntegerRef indexPagesSpace() const { return _indexPagesSpace; }
  /** Setter for attribute indexPagesSpace
   
    Space used of the index pages in the B* tree (as a percentage)
    \par In Python:
obj.indexPagesSpace = value
   */
  virtual void indexPagesSpace(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_indexPagesSpace);
   _indexPagesSpace= value;
    member_changed("indexPagesSpace", ovalue, value);
  }

  /** Getter for attribute indexUsed
   
    Has this index be accessed in the past?
   \par In Python:
value = obj.indexUsed
   */
  grt::IntegerRef indexUsed() const { return _indexUsed; }
  /** Setter for attribute indexUsed
   
    Has this index be accessed in the past?
    \par In Python:
obj.indexUsed = value
   */
  virtual void indexUsed(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_indexUsed);
   _indexUsed= value;
    member_changed("indexUsed", ovalue, value);
  }

  /** Getter for attribute leafPages
   
    Indicates how many leaf pages are used by the index
   \par In Python:
value = obj.leafPages
   */
  grt::IntegerRef leafPages() const { return _leafPages; }
  /** Setter for attribute leafPages
   
    Indicates how many leaf pages are used by the index
    \par In Python:
obj.leafPages = value
   */
  virtual void leafPages(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_leafPages);
   _leafPages= value;
    member_changed("leafPages", ovalue, value);
  }

  /** Getter for attribute leafPagesSpace
   
    Contains the used space of the leaf pages in the B* tree (as a percentage)
   \par In Python:
value = obj.leafPagesSpace
   */
  grt::IntegerRef leafPagesSpace() const { return _leafPagesSpace; }
  /** Setter for attribute leafPagesSpace
   
    Contains the used space of the leaf pages in the B* tree (as a percentage)
    \par In Python:
obj.leafPagesSpace = value
   */
  virtual void leafPagesSpace(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_leafPagesSpace);
   _leafPagesSpace= value;
    member_changed("leafPagesSpace", ovalue, value);
  }

  /** Getter for attribute leafPagesSpaceMax
   
    Contains the maximum used space of the leaf pages in the B* tree (as a percentage)
   \par In Python:
value = obj.leafPagesSpaceMax
   */
  grt::IntegerRef leafPagesSpaceMax() const { return _leafPagesSpaceMax; }
  /** Setter for attribute leafPagesSpaceMax
   
    Contains the maximum used space of the leaf pages in the B* tree (as a percentage)
    \par In Python:
obj.leafPagesSpaceMax = value
   */
  virtual void leafPagesSpaceMax(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_leafPagesSpaceMax);
   _leafPagesSpaceMax= value;
    member_changed("leafPagesSpaceMax", ovalue, value);
  }

  /** Getter for attribute leafPagesSpaceMin
   
    Contains the minimum used space of the leaf pages in the B* tree (as a percentage)
   \par In Python:
value = obj.leafPagesSpaceMin
   */
  grt::IntegerRef leafPagesSpaceMin() const { return _leafPagesSpaceMin; }
  /** Setter for attribute leafPagesSpaceMin
   
    Contains the minimum used space of the leaf pages in the B* tree (as a percentage)
    \par In Python:
obj.leafPagesSpaceMin = value
   */
  virtual void leafPagesSpaceMin(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_leafPagesSpaceMin);
   _leafPagesSpaceMin= value;
    member_changed("leafPagesSpaceMin", ovalue, value);
  }

  /** Getter for attribute maxNumPkPerList
   
    Primary key: contains the maximum number of keys for each invert list
   \par In Python:
value = obj.maxNumPkPerList
   */
  grt::IntegerRef maxNumPkPerList() const { return _maxNumPkPerList; }
  /** Setter for attribute maxNumPkPerList
   
    Primary key: contains the maximum number of keys for each invert list
    \par In Python:
obj.maxNumPkPerList = value
   */
  virtual void maxNumPkPerList(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_maxNumPkPerList);
   _maxNumPkPerList= value;
    member_changed("maxNumPkPerList", ovalue, value);
  }

  /** Getter for attribute maxSeperatorLength
   
    
   \par In Python:
value = obj.maxSeperatorLength
   */
  grt::IntegerRef maxSeperatorLength() const { return _maxSeperatorLength; }
  /** Setter for attribute maxSeperatorLength
   
    
    \par In Python:
obj.maxSeperatorLength = value
   */
  virtual void maxSeperatorLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_maxSeperatorLength);
   _maxSeperatorLength= value;
    member_changed("maxSeperatorLength", ovalue, value);
  }

  /** Getter for attribute maxSkLength
   
    Contains the maximum length of an index value
   \par In Python:
value = obj.maxSkLength
   */
  grt::IntegerRef maxSkLength() const { return _maxSkLength; }
  /** Setter for attribute maxSkLength
   
    Contains the maximum length of an index value
    \par In Python:
obj.maxSkLength = value
   */
  virtual void maxSkLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_maxSkLength);
   _maxSkLength= value;
    member_changed("maxSkLength", ovalue, value);
  }

  /** Getter for attribute minNumPkPerList
   
    Primary key: contains the minimum number of keys for each invert list
   \par In Python:
value = obj.minNumPkPerList
   */
  grt::IntegerRef minNumPkPerList() const { return _minNumPkPerList; }
  /** Setter for attribute minNumPkPerList
   
    Primary key: contains the minimum number of keys for each invert list
    \par In Python:
obj.minNumPkPerList = value
   */
  virtual void minNumPkPerList(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_minNumPkPerList);
   _minNumPkPerList= value;
    member_changed("minNumPkPerList", ovalue, value);
  }

  /** Getter for attribute minSeperatorLength
   
    
   \par In Python:
value = obj.minSeperatorLength
   */
  grt::IntegerRef minSeperatorLength() const { return _minSeperatorLength; }
  /** Setter for attribute minSeperatorLength
   
    
    \par In Python:
obj.minSeperatorLength = value
   */
  virtual void minSeperatorLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_minSeperatorLength);
   _minSeperatorLength= value;
    member_changed("minSeperatorLength", ovalue, value);
  }

  /** Getter for attribute minSkLength
   
    Contains the minimum length of an index value
   \par In Python:
value = obj.minSkLength
   */
  grt::IntegerRef minSkLength() const { return _minSkLength; }
  /** Setter for attribute minSkLength
   
    Contains the minimum length of an index value
    \par In Python:
obj.minSkLength = value
   */
  virtual void minSkLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_minSkLength);
   _minSkLength= value;
    member_changed("minSkLength", ovalue, value);
  }

  /** Getter for attribute numDistinctValues
   
    Only for secondary keys: number of different values of the indexed columns
   \par In Python:
value = obj.numDistinctValues
   */
  grt::IntegerRef numDistinctValues() const { return _numDistinctValues; }
  /** Setter for attribute numDistinctValues
   
    Only for secondary keys: number of different values of the indexed columns
    \par In Python:
obj.numDistinctValues = value
   */
  virtual void numDistinctValues(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_numDistinctValues);
   _numDistinctValues= value;
    member_changed("numDistinctValues", ovalue, value);
  }

  /** Getter for attribute numRowsPk
   
    Primary key: contains the number of rows in the table
   \par In Python:
value = obj.numRowsPk
   */
  grt::IntegerRef numRowsPk() const { return _numRowsPk; }
  /** Setter for attribute numRowsPk
   
    Primary key: contains the number of rows in the table
    \par In Python:
obj.numRowsPk = value
   */
  virtual void numRowsPk(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_numRowsPk);
   _numRowsPk= value;
    member_changed("numRowsPk", ovalue, value);
  }

  /** Getter for attribute rootPage
   
    Page number of the root of the B* tree
   \par In Python:
value = obj.rootPage
   */
  grt::IntegerRef rootPage() const { return _rootPage; }
  /** Setter for attribute rootPage
   
    Page number of the root of the B* tree
    \par In Python:
obj.rootPage = value
   */
  virtual void rootPage(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_rootPage);
   _rootPage= value;
    member_changed("rootPage", ovalue, value);
  }

  /** Getter for attribute rootPageSpace
   
    Space used of the root page in the B* tree (as a percentage)
   \par In Python:
value = obj.rootPageSpace
   */
  grt::IntegerRef rootPageSpace() const { return _rootPageSpace; }
  /** Setter for attribute rootPageSpace
   
    Space used of the root page in the B* tree (as a percentage)
    \par In Python:
obj.rootPageSpace = value
   */
  virtual void rootPageSpace(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_rootPageSpace);
   _rootPageSpace= value;
    member_changed("rootPageSpace", ovalue, value);
  }

  /** Getter for attribute selectivityGreater25Percent
   
    Values with selectivity > 25%
   \par In Python:
value = obj.selectivityGreater25Percent
   */
  grt::IntegerRef selectivityGreater25Percent() const { return _selectivityGreater25Percent; }
  /** Setter for attribute selectivityGreater25Percent
   
    Values with selectivity > 25%
    \par In Python:
obj.selectivityGreater25Percent = value
   */
  virtual void selectivityGreater25Percent(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_selectivityGreater25Percent);
   _selectivityGreater25Percent= value;
    member_changed("selectivityGreater25Percent", ovalue, value);
  }

  /** Getter for attribute selectivityLess10Percent
   
    Values with selectivity <= 10%, selectivity between 5% and 10%
   \par In Python:
value = obj.selectivityLess10Percent
   */
  grt::IntegerRef selectivityLess10Percent() const { return _selectivityLess10Percent; }
  /** Setter for attribute selectivityLess10Percent
   
    Values with selectivity <= 10%, selectivity between 5% and 10%
    \par In Python:
obj.selectivityLess10Percent = value
   */
  virtual void selectivityLess10Percent(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_selectivityLess10Percent);
   _selectivityLess10Percent= value;
    member_changed("selectivityLess10Percent", ovalue, value);
  }

  /** Getter for attribute selectivityLess1Percent
   
    Values with selectivity <= 1%, selectivity less or equal 1%
   \par In Python:
value = obj.selectivityLess1Percent
   */
  grt::IntegerRef selectivityLess1Percent() const { return _selectivityLess1Percent; }
  /** Setter for attribute selectivityLess1Percent
   
    Values with selectivity <= 1%, selectivity less or equal 1%
    \par In Python:
obj.selectivityLess1Percent = value
   */
  virtual void selectivityLess1Percent(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_selectivityLess1Percent);
   _selectivityLess1Percent= value;
    member_changed("selectivityLess1Percent", ovalue, value);
  }

  /** Getter for attribute selectivityLess25Percent
   
    Values with selectivity %lt;= 25%, selectivity between 10% and 25%
   \par In Python:
value = obj.selectivityLess25Percent
   */
  grt::IntegerRef selectivityLess25Percent() const { return _selectivityLess25Percent; }
  /** Setter for attribute selectivityLess25Percent
   
    Values with selectivity %lt;= 25%, selectivity between 10% and 25%
    \par In Python:
obj.selectivityLess25Percent = value
   */
  virtual void selectivityLess25Percent(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_selectivityLess25Percent);
   _selectivityLess25Percent= value;
    member_changed("selectivityLess25Percent", ovalue, value);
  }

  /** Getter for attribute selectivityLess5Percent
   
    Values with selectivity <= 5%, selectivity between 1% and 5%
   \par In Python:
value = obj.selectivityLess5Percent
   */
  grt::IntegerRef selectivityLess5Percent() const { return _selectivityLess5Percent; }
  /** Setter for attribute selectivityLess5Percent
   
    Values with selectivity <= 5%, selectivity between 1% and 5%
    \par In Python:
obj.selectivityLess5Percent = value
   */
  virtual void selectivityLess5Percent(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_selectivityLess5Percent);
   _selectivityLess5Percent= value;
    member_changed("selectivityLess5Percent", ovalue, value);
  }

  /** Getter for attribute totalSpaceUsed
   
    Space used of all pages in the B* tree (as a percentage)
   \par In Python:
value = obj.totalSpaceUsed
   */
  grt::IntegerRef totalSpaceUsed() const { return _totalSpaceUsed; }
  /** Setter for attribute totalSpaceUsed
   
    Space used of all pages in the B* tree (as a percentage)
    \par In Python:
obj.totalSpaceUsed = value
   */
  virtual void totalSpaceUsed(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_totalSpaceUsed);
   _totalSpaceUsed= value;
    member_changed("totalSpaceUsed", ovalue, value);
  }

  /** Getter for attribute usedPages
   
    Indicates how many pages are used by the index
   \par In Python:
value = obj.usedPages
   */
  grt::IntegerRef usedPages() const { return _usedPages; }
  /** Setter for attribute usedPages
   
    Indicates how many pages are used by the index
    \par In Python:
obj.usedPages = value
   */
  virtual void usedPages(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_usedPages);
   _usedPages= value;
    member_changed("usedPages", ovalue, value);
  }

protected:

  grt::IntegerRef _averageSkLength;
  grt::IntegerRef _avgNumPkPerList;
  grt::IntegerRef _avgSeperatorLength;
  grt::StringRef _createDate;
  grt::StringRef _createTime;
  grt::IntegerRef _disabled;
  grt::StringRef _fileid;
  grt::StringRef _filestate;
  grt::StringRef _filetype;
  grt::IntegerRef _indexLevels;
  grt::IntegerRef _indexPageSpaceMax;
  grt::IntegerRef _indexPageSpaceMin;
  grt::IntegerRef _indexPages;
  grt::IntegerRef _indexPagesSpace;
  grt::IntegerRef _indexUsed;
  grt::IntegerRef _leafPages;
  grt::IntegerRef _leafPagesSpace;
  grt::IntegerRef _leafPagesSpaceMax;
  grt::IntegerRef _leafPagesSpaceMin;
  grt::IntegerRef _maxNumPkPerList;
  grt::IntegerRef _maxSeperatorLength;
  grt::IntegerRef _maxSkLength;
  grt::IntegerRef _minNumPkPerList;
  grt::IntegerRef _minSeperatorLength;
  grt::IntegerRef _minSkLength;
  grt::IntegerRef _numDistinctValues;
  grt::IntegerRef _numRowsPk;
  grt::IntegerRef _rootPage;
  grt::IntegerRef _rootPageSpace;
  grt::IntegerRef _selectivityGreater25Percent;
  grt::IntegerRef _selectivityLess10Percent;
  grt::IntegerRef _selectivityLess1Percent;
  grt::IntegerRef _selectivityLess25Percent;
  grt::IntegerRef _selectivityLess5Percent;
  grt::IntegerRef _totalSpaceUsed;
  grt::IntegerRef _usedPages;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Index(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Index::create);
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::averageSkLength;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::averageSkLength;
      meta->bind_member("averageSkLength", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::avgNumPkPerList;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::avgNumPkPerList;
      meta->bind_member("avgNumPkPerList", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::avgSeperatorLength;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::avgSeperatorLength;
      meta->bind_member("avgSeperatorLength", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Index::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::StringRef &)= &db_maxdb_Index::createDate;
      grt::StringRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::createDate;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::StringRef &)= &db_maxdb_Index::createTime;
      grt::StringRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::disabled;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::disabled;
      meta->bind_member("disabled", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::StringRef &)= &db_maxdb_Index::fileid;
      grt::StringRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::fileid;
      meta->bind_member("fileid", new grt::MetaClass::Property<db_maxdb_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::StringRef &)= &db_maxdb_Index::filestate;
      grt::StringRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::filestate;
      meta->bind_member("filestate", new grt::MetaClass::Property<db_maxdb_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::StringRef &)= &db_maxdb_Index::filetype;
      grt::StringRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::filetype;
      meta->bind_member("filetype", new grt::MetaClass::Property<db_maxdb_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::indexLevels;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::indexLevels;
      meta->bind_member("indexLevels", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::indexPageSpaceMax;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::indexPageSpaceMax;
      meta->bind_member("indexPageSpaceMax", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::indexPageSpaceMin;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::indexPageSpaceMin;
      meta->bind_member("indexPageSpaceMin", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::indexPages;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::indexPages;
      meta->bind_member("indexPages", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::indexPagesSpace;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::indexPagesSpace;
      meta->bind_member("indexPagesSpace", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::indexUsed;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::indexUsed;
      meta->bind_member("indexUsed", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::leafPages;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::leafPages;
      meta->bind_member("leafPages", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::leafPagesSpace;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::leafPagesSpace;
      meta->bind_member("leafPagesSpace", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::leafPagesSpaceMax;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::leafPagesSpaceMax;
      meta->bind_member("leafPagesSpaceMax", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::leafPagesSpaceMin;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::leafPagesSpaceMin;
      meta->bind_member("leafPagesSpaceMin", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::maxNumPkPerList;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::maxNumPkPerList;
      meta->bind_member("maxNumPkPerList", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::maxSeperatorLength;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::maxSeperatorLength;
      meta->bind_member("maxSeperatorLength", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::maxSkLength;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::maxSkLength;
      meta->bind_member("maxSkLength", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::minNumPkPerList;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::minNumPkPerList;
      meta->bind_member("minNumPkPerList", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::minSeperatorLength;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::minSeperatorLength;
      meta->bind_member("minSeperatorLength", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::minSkLength;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::minSkLength;
      meta->bind_member("minSkLength", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::numDistinctValues;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::numDistinctValues;
      meta->bind_member("numDistinctValues", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::numRowsPk;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::numRowsPk;
      meta->bind_member("numRowsPk", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::rootPage;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::rootPage;
      meta->bind_member("rootPage", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::rootPageSpace;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::rootPageSpace;
      meta->bind_member("rootPageSpace", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::selectivityGreater25Percent;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::selectivityGreater25Percent;
      meta->bind_member("selectivityGreater25Percent", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::selectivityLess10Percent;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::selectivityLess10Percent;
      meta->bind_member("selectivityLess10Percent", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::selectivityLess1Percent;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::selectivityLess1Percent;
      meta->bind_member("selectivityLess1Percent", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::selectivityLess25Percent;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::selectivityLess25Percent;
      meta->bind_member("selectivityLess25Percent", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::selectivityLess5Percent;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::selectivityLess5Percent;
      meta->bind_member("selectivityLess5Percent", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::totalSpaceUsed;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::totalSpaceUsed;
      meta->bind_member("totalSpaceUsed", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Index::*setter)(const grt::IntegerRef &)= &db_maxdb_Index::usedPages;
      grt::IntegerRef (db_maxdb_Index::*getter)() const= &db_maxdb_Index::usedPages;
      meta->bind_member("usedPages", new grt::MetaClass::Property<db_maxdb_Index,grt::IntegerRef >(getter,setter));
    }
  }
};


  /** a MaxDB structured datatype object */
class  db_maxdb_StructuredDatatype : public db_StructuredDatatype
{
  typedef db_StructuredDatatype super;
public:
  db_maxdb_StructuredDatatype(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_StructuredDatatype(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "db.maxdb.StructuredDatatype"; }

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_StructuredDatatype(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_StructuredDatatype::create);
  }
};


class  db_maxdb_SimpleDatatype : public db_SimpleDatatype
{
  typedef db_SimpleDatatype super;
public:
  db_maxdb_SimpleDatatype(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_SimpleDatatype(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "db.maxdb.SimpleDatatype"; }

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_SimpleDatatype(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_SimpleDatatype::create);
  }
};


class  db_maxdb_Column : public db_Column
{
  typedef db_Column super;
public:
  db_maxdb_Column(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Column(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _alterDate(""),
     _alterTime(""),
     _codeType(""),
     _createDate(""),
     _createTime(""),
     _defaultFunction(""),
     _domainName(""),
     _domainOwner(""),
     _privileges("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.Column"; }

  /** Getter for attribute alterDate
   
    Change date of column
   \par In Python:
value = obj.alterDate
   */
  grt::StringRef alterDate() const { return _alterDate; }
  /** Setter for attribute alterDate
   
    Change date of column
    \par In Python:
obj.alterDate = value
   */
  virtual void alterDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_alterDate);
   _alterDate= value;
    member_changed("alterDate", ovalue, value);
  }

  /** Getter for attribute alterTime
   
    Change time of column
   \par In Python:
value = obj.alterTime
   */
  grt::StringRef alterTime() const { return _alterTime; }
  /** Setter for attribute alterTime
   
    Change time of column
    \par In Python:
obj.alterTime = value
   */
  virtual void alterTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_alterTime);
   _alterTime= value;
    member_changed("alterTime", ovalue, value);
  }

  /** Getter for attribute codeType
   
    Code attribute of column (ASCII | BYTE | UNICODE)
   \par In Python:
value = obj.codeType
   */
  grt::StringRef codeType() const { return _codeType; }
  /** Setter for attribute codeType
   
    Code attribute of column (ASCII | BYTE | UNICODE)
    \par In Python:
obj.codeType = value
   */
  virtual void codeType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_codeType);
   _codeType= value;
    member_changed("codeType", ovalue, value);
  }

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  grt::StringRef createDate() const { return _createDate; }
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */
  virtual void createDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createDate);
   _createDate= value;
    member_changed("createDate", ovalue, value);
  }

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

  /** Getter for attribute defaultFunction
   
    
   \par In Python:
value = obj.defaultFunction
   */
  grt::StringRef defaultFunction() const { return _defaultFunction; }
  /** Setter for attribute defaultFunction
   
    
    \par In Python:
obj.defaultFunction = value
   */
  virtual void defaultFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultFunction);
   _defaultFunction= value;
    member_changed("defaultFunction", ovalue, value);
  }

  /** Getter for attribute domainName
   
    Name of domain
   \par In Python:
value = obj.domainName
   */
  grt::StringRef domainName() const { return _domainName; }
  /** Setter for attribute domainName
   
    Name of domain
    \par In Python:
obj.domainName = value
   */
  virtual void domainName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_domainName);
   _domainName= value;
    member_changed("domainName", ovalue, value);
  }

  /** Getter for attribute domainOwner
   
    Name of domain owner
   \par In Python:
value = obj.domainOwner
   */
  grt::StringRef domainOwner() const { return _domainOwner; }
  /** Setter for attribute domainOwner
   
    Name of domain owner
    \par In Python:
obj.domainOwner = value
   */
  virtual void domainOwner(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_domainOwner);
   _domainOwner= value;
    member_changed("domainOwner", ovalue, value);
  }

  /** Getter for attribute privileges
   
    Privileges of current user for column
   \par In Python:
value = obj.privileges
   */
  grt::StringRef privileges() const { return _privileges; }
  /** Setter for attribute privileges
   
    Privileges of current user for column
    \par In Python:
obj.privileges = value
   */
  virtual void privileges(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_privileges);
   _privileges= value;
    member_changed("privileges", ovalue, value);
  }

protected:

  grt::StringRef _alterDate;
  grt::StringRef _alterTime;
  grt::StringRef _codeType;
  grt::StringRef _createDate;
  grt::StringRef _createTime;
  grt::StringRef _defaultFunction;
  grt::StringRef _domainName;
  grt::StringRef _domainOwner;
  grt::StringRef _privileges;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Column(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Column::create);
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::alterDate;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::alterDate;
      meta->bind_member("alterDate", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::alterTime;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::alterTime;
      meta->bind_member("alterTime", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::codeType;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::codeType;
      meta->bind_member("codeType", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::createDate;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::createDate;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::createTime;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::defaultFunction;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::defaultFunction;
      meta->bind_member("defaultFunction", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::domainName;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::domainName;
      meta->bind_member("domainName", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::domainOwner;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::domainOwner;
      meta->bind_member("domainOwner", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Column::*setter)(const grt::StringRef &)= &db_maxdb_Column::privileges;
      grt::StringRef (db_maxdb_Column::*getter)() const= &db_maxdb_Column::privileges;
      meta->bind_member("privileges", new grt::MetaClass::Property<db_maxdb_Column,grt::StringRef >(getter,setter));
    }
  }
};


class  db_maxdb_Table : public db_Table
{
  typedef db_Table super;
public:
  db_maxdb_Table(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Table(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _alterDate(""),
     _alterTime(""),
     _archive(""),
     _createTime(""),
     _noFixedLengthColumn(0),
     _privileges(""),
     _sample(""),
     _tableid(""),
     _unloaded(""),
     _updStatDate(""),
     _updStatTime(""),
     _variableColumns("")

  {
  }

  static std::string static_class_name() { return "db.maxdb.Table"; }

  /** Getter for attribute alterDate
   
    Change date of table
   \par In Python:
value = obj.alterDate
   */
  grt::StringRef alterDate() const { return _alterDate; }
  /** Setter for attribute alterDate
   
    Change date of table
    \par In Python:
obj.alterDate = value
   */
  virtual void alterDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_alterDate);
   _alterDate= value;
    member_changed("alterDate", ovalue, value);
  }

  /** Getter for attribute alterTime
   
    Change time of table
   \par In Python:
value = obj.alterTime
   */
  grt::StringRef alterTime() const { return _alterTime; }
  /** Setter for attribute alterTime
   
    Change time of table
    \par In Python:
obj.alterTime = value
   */
  virtual void alterTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_alterTime);
   _alterTime= value;
    member_changed("alterTime", ovalue, value);
  }

  /** Getter for attribute archive
   
    Table was defined with FOR ARCHIVE option (YES|NO)
   \par In Python:
value = obj.archive
   */
  grt::StringRef archive() const { return _archive; }
  /** Setter for attribute archive
   
    Table was defined with FOR ARCHIVE option (YES|NO)
    \par In Python:
obj.archive = value
   */
  virtual void archive(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_archive);
   _archive= value;
    member_changed("archive", ovalue, value);
  }

  /** Getter for attribute comment
   
    Comment about table
   \par In Python:
value = obj.comment
   */
  /** Setter for attribute comment
   
    Comment about table
    \par In Python:
obj.comment = value
   */

  /** Getter for attribute createDate
   
    Creation date
   \par In Python:
value = obj.createDate
   */
  /** Setter for attribute createDate
   
    Creation date
    \par In Python:
obj.createDate = value
   */

  /** Getter for attribute createTime
   
    Creation time
   \par In Python:
value = obj.createTime
   */
  grt::StringRef createTime() const { return _createTime; }
  /** Setter for attribute createTime
   
    Creation time
    \par In Python:
obj.createTime = value
   */
  virtual void createTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createTime);
   _createTime= value;
    member_changed("createTime", ovalue, value);
  }

  /** Getter for attribute noFixedLengthColumn
   
    Forces the usage of variable length style storage for all columns no matter what their data type is.
   \par In Python:
value = obj.noFixedLengthColumn
   */
  grt::IntegerRef noFixedLengthColumn() const { return _noFixedLengthColumn; }
  /** Setter for attribute noFixedLengthColumn
   
    Forces the usage of variable length style storage for all columns no matter what their data type is.
    \par In Python:
obj.noFixedLengthColumn = value
   */
  virtual void noFixedLengthColumn(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_noFixedLengthColumn);
   _noFixedLengthColumn= value;
    member_changed("noFixedLengthColumn", ovalue, value);
  }

  /** Getter for attribute privileges
   
    Privileges that current user has for the table
   \par In Python:
value = obj.privileges
   */
  grt::StringRef privileges() const { return _privileges; }
  /** Setter for attribute privileges
   
    Privileges that current user has for the table
    \par In Python:
obj.privileges = value
   */
  virtual void privileges(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_privileges);
   _privileges= value;
    member_changed("privileges", ovalue, value);
  }

  /** Getter for attribute sample
   
    Sample size definitions used to update statistics.
   \par In Python:
value = obj.sample
   */
  grt::StringRef sample() const { return _sample; }
  /** Setter for attribute sample
   
    Sample size definitions used to update statistics.
    \par In Python:
obj.sample = value
   */
  virtual void sample(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_sample);
   _sample= value;
    member_changed("sample", ovalue, value);
  }

  /** Getter for attribute tableid
   
    Table ID in hexadecimal format
   \par In Python:
value = obj.tableid
   */
  grt::StringRef tableid() const { return _tableid; }
  /** Setter for attribute tableid
   
    Table ID in hexadecimal format
    \par In Python:
obj.tableid = value
   */
  virtual void tableid(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_tableid);
   _tableid= value;
    member_changed("tableid", ovalue, value);
  }

  /** Getter for attribute unloaded
   
    Table is unloaded (YES | NO)
   \par In Python:
value = obj.unloaded
   */
  grt::StringRef unloaded() const { return _unloaded; }
  /** Setter for attribute unloaded
   
    Table is unloaded (YES | NO)
    \par In Python:
obj.unloaded = value
   */
  virtual void unloaded(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_unloaded);
   _unloaded= value;
    member_changed("unloaded", ovalue, value);
  }

  /** Getter for attribute updStatDate
   
    Date of last UPDATE STATISTICS statement for table
   \par In Python:
value = obj.updStatDate
   */
  grt::StringRef updStatDate() const { return _updStatDate; }
  /** Setter for attribute updStatDate
   
    Date of last UPDATE STATISTICS statement for table
    \par In Python:
obj.updStatDate = value
   */
  virtual void updStatDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_updStatDate);
   _updStatDate= value;
    member_changed("updStatDate", ovalue, value);
  }

  /** Getter for attribute updStatTime
   
    Time of last UPDATE STATISTICS statement for table
   \par In Python:
value = obj.updStatTime
   */
  grt::StringRef updStatTime() const { return _updStatTime; }
  /** Setter for attribute updStatTime
   
    Time of last UPDATE STATISTICS statement for table
    \par In Python:
obj.updStatTime = value
   */
  virtual void updStatTime(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_updStatTime);
   _updStatTime= value;
    member_changed("updStatTime", ovalue, value);
  }

  /** Getter for attribute variableColumns
   
    Columns stored with variable length (YES|NO); see CREATE TABLE Statement in the MaxDB Library
   \par In Python:
value = obj.variableColumns
   */
  grt::StringRef variableColumns() const { return _variableColumns; }
  /** Setter for attribute variableColumns
   
    Columns stored with variable length (YES|NO); see CREATE TABLE Statement in the MaxDB Library
    \par In Python:
obj.variableColumns = value
   */
  virtual void variableColumns(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_variableColumns);
   _variableColumns= value;
    member_changed("variableColumns", ovalue, value);
  }

protected:

  grt::StringRef _alterDate;
  grt::StringRef _alterTime;
  grt::StringRef _archive;
  grt::StringRef _createTime;
  grt::IntegerRef _noFixedLengthColumn;
  grt::StringRef _privileges;
  grt::StringRef _sample;
  grt::StringRef _tableid;
  grt::StringRef _unloaded;
  grt::StringRef _updStatDate;
  grt::StringRef _updStatTime;
  grt::StringRef _variableColumns;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Table(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Table::create);
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::alterDate;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::alterDate;
      meta->bind_member("alterDate", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::alterTime;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::alterTime;
      meta->bind_member("alterTime", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::archive;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::archive;
      meta->bind_member("archive", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Table::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_maxdb_Table::*getter)() const= 0;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::createTime;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::createTime;
      meta->bind_member("createTime", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::IntegerRef &)= &db_maxdb_Table::noFixedLengthColumn;
      grt::IntegerRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::noFixedLengthColumn;
      meta->bind_member("noFixedLengthColumn", new grt::MetaClass::Property<db_maxdb_Table,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::privileges;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::privileges;
      meta->bind_member("privileges", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::sample;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::sample;
      meta->bind_member("sample", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::tableid;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::tableid;
      meta->bind_member("tableid", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::unloaded;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::unloaded;
      meta->bind_member("unloaded", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::updStatDate;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::updStatDate;
      meta->bind_member("updStatDate", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::updStatTime;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::updStatTime;
      meta->bind_member("updStatTime", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_maxdb_Table::*setter)(const grt::StringRef &)= &db_maxdb_Table::variableColumns;
      grt::StringRef (db_maxdb_Table::*getter)() const= &db_maxdb_Table::variableColumns;
      meta->bind_member("variableColumns", new grt::MetaClass::Property<db_maxdb_Table,grt::StringRef >(getter,setter));
    }
  }
};


class  db_maxdb_Schema : public db_Schema
{
  typedef db_Schema super;
public:
  db_maxdb_Schema(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Schema(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
    _routineGroups.content().__retype(grt::ObjectType, "db.maxdb.RoutineGroup");
    _routines.content().__retype(grt::ObjectType, "db.maxdb.Routine");
    _sequences.content().__retype(grt::ObjectType, "db.maxdb.Sequence");
    _structuredTypes.content().__retype(grt::ObjectType, "db.maxdb.StructuredDatatype");
    _synonyms.content().__retype(grt::ObjectType, "db.maxdb.Synonym");
    _tables.content().__retype(grt::ObjectType, "db.maxdb.Table");
    _views.content().__retype(grt::ObjectType, "db.maxdb.View");
  }

  static std::string static_class_name() { return "db.maxdb.Schema"; }

  // routineGroups is owned by db_maxdb_Schema
  /** Getter for attribute routineGroups (read-only)
   
    
   \par In Python:
value = obj.routineGroups
   */
  grt::ListRef<db_maxdb_RoutineGroup> routineGroups() const { return grt::ListRef<db_maxdb_RoutineGroup>::cast_from(_routineGroups); }
private: // the next attribute is read-only
public:

  // routines is owned by db_maxdb_Schema
  /** Getter for attribute routines (read-only)
   
    
   \par In Python:
value = obj.routines
   */
  grt::ListRef<db_maxdb_Routine> routines() const { return grt::ListRef<db_maxdb_Routine>::cast_from(_routines); }
private: // the next attribute is read-only
public:

  // sequences is owned by db_maxdb_Schema
  /** Getter for attribute sequences (read-only)
   
    
   \par In Python:
value = obj.sequences
   */
  grt::ListRef<db_maxdb_Sequence> sequences() const { return grt::ListRef<db_maxdb_Sequence>::cast_from(_sequences); }
private: // the next attribute is read-only
public:

  // structuredTypes is owned by db_maxdb_Schema
  /** Getter for attribute structuredTypes (read-only)
   
    
   \par In Python:
value = obj.structuredTypes
   */
  grt::ListRef<db_maxdb_StructuredDatatype> structuredTypes() const { return grt::ListRef<db_maxdb_StructuredDatatype>::cast_from(_structuredTypes); }
private: // the next attribute is read-only
public:

  // synonyms is owned by db_maxdb_Schema
  /** Getter for attribute synonyms (read-only)
   
    
   \par In Python:
value = obj.synonyms
   */
  grt::ListRef<db_maxdb_Synonym> synonyms() const { return grt::ListRef<db_maxdb_Synonym>::cast_from(_synonyms); }
private: // the next attribute is read-only
public:

  // tables is owned by db_maxdb_Schema
  /** Getter for attribute tables (read-only)
   
    
   \par In Python:
value = obj.tables
   */
  grt::ListRef<db_maxdb_Table> tables() const { return grt::ListRef<db_maxdb_Table>::cast_from(_tables); }
private: // the next attribute is read-only
public:

  // views is owned by db_maxdb_Schema
  /** Getter for attribute views (read-only)
   
    
   \par In Python:
value = obj.views
   */
  grt::ListRef<db_maxdb_View> views() const { return grt::ListRef<db_maxdb_View>::cast_from(_views); }
private: // the next attribute is read-only
public:

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Schema(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Schema::create);
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_RoutineGroup> &)= 0;
      grt::ListRef<db_maxdb_RoutineGroup> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("routineGroups", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_RoutineGroup> >(getter,setter));
    }
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_Routine> &)= 0;
      grt::ListRef<db_maxdb_Routine> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("routines", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_Routine> >(getter,setter));
    }
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_Sequence> &)= 0;
      grt::ListRef<db_maxdb_Sequence> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("sequences", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_Sequence> >(getter,setter));
    }
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_StructuredDatatype> &)= 0;
      grt::ListRef<db_maxdb_StructuredDatatype> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("structuredTypes", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_StructuredDatatype> >(getter,setter));
    }
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_Synonym> &)= 0;
      grt::ListRef<db_maxdb_Synonym> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("synonyms", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_Synonym> >(getter,setter));
    }
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_Table> &)= 0;
      grt::ListRef<db_maxdb_Table> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("tables", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_Table> >(getter,setter));
    }
    {
      void (db_maxdb_Schema::*setter)(const grt::ListRef<db_maxdb_View> &)= 0;
      grt::ListRef<db_maxdb_View> (db_maxdb_Schema::*getter)() const= 0;
      meta->bind_member("views", new grt::MetaClass::Property<db_maxdb_Schema,grt::ListRef<db_maxdb_View> >(getter,setter));
    }
  }
};


class  db_maxdb_Catalog : public db_Catalog
{
  typedef db_Catalog super;
public:
  db_maxdb_Catalog(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_Catalog(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
    _schemata.content().__retype(grt::ObjectType, "db.maxdb.Schema");
  }

  static std::string static_class_name() { return "db.maxdb.Catalog"; }

  // schemata is owned by db_maxdb_Catalog
  /** Getter for attribute schemata (read-only)
   
    
   \par In Python:
value = obj.schemata
   */
  grt::ListRef<db_maxdb_Schema> schemata() const { return grt::ListRef<db_maxdb_Schema>::cast_from(_schemata); }
private: // the next attribute is read-only
public:

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_maxdb_Catalog(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_maxdb_Catalog::create);
    {
      void (db_maxdb_Catalog::*setter)(const grt::ListRef<db_maxdb_Schema> &)= 0;
      grt::ListRef<db_maxdb_Schema> (db_maxdb_Catalog::*getter)() const= 0;
      meta->bind_member("schemata", new grt::MetaClass::Property<db_maxdb_Catalog,grt::ListRef<db_maxdb_Schema> >(getter,setter));
    }
  }
};




inline void register_structs_db_maxdb_xml()
{
  grt::internal::ClassRegistry::register_class<db_maxdb_Sequence>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Synonym>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Routine>();
  grt::internal::ClassRegistry::register_class<db_maxdb_RoutineGroup>();
  grt::internal::ClassRegistry::register_class<db_maxdb_View>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Trigger>();
  grt::internal::ClassRegistry::register_class<db_maxdb_ForeignKey>();
  grt::internal::ClassRegistry::register_class<db_maxdb_IndexColumn>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Index>();
  grt::internal::ClassRegistry::register_class<db_maxdb_StructuredDatatype>();
  grt::internal::ClassRegistry::register_class<db_maxdb_SimpleDatatype>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Column>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Table>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Schema>();
  grt::internal::ClassRegistry::register_class<db_maxdb_Catalog>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_db_maxdb_xml { _autoreg__structs_db_maxdb_xml() { register_structs_db_maxdb_xml(); } } __autoreg__structs_db_maxdb_xml;
#endif

#endif
