/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "geometry.h"

using namespace MySQL::Geometry;

//----------------- Rect ---------------------------------------------------------------------------

Rect::Rect()
{
  left= 0;
  top= 0;
  width= 0;
  height= 0;
}

//--------------------------------------------------------------------------------------------------

Rect::Rect(double x, double y, double w, double h)
{
  left= x;
  top= y;
  width= w;
  height= h;
}

//--------------------------------------------------------------------------------------------------

bool Rect::contains(double x, double y)
{
  return !empty() && (x >= left) && (x <= left + width) &&
    (y >= top) && (y <= top + height);
}

//--------------------------------------------------------------------------------------------------

bool Rect::contains_flipped(double x, double y)
{
  // For cairo text the top is actually the bottom (when using it for hit tests).
  return !empty() && (x >= left) && (x <= left + width) &&
    (y >= top - height) && (y <= top);
}

//--------------------------------------------------------------------------------------------------

/**
 * Inflates the rectangle by adding the given amounts to the left/top coordinate and subtracting them
 * from the right/bottom coordinate.
 */
void Rect::inflate(double horizontal, double vertical)
{
  left += horizontal;
  width -= 2 * horizontal;
  top += vertical;
  height -= 2 * vertical;
}

//--------------------------------------------------------------------------------------------------

double Rect::right()
{
  return left + width;
}

//--------------------------------------------------------------------------------------------------

double Rect::bottom()
{
  return top + height;
}

//--------------------------------------------------------------------------------------------------

bool Rect::empty()
{
  return (width <= 0) || (height <= 0);
}

//----------------- Point --------------------------------------------------------------------------

Point::Point()
{
  x= 0;
  y= 0;
}

//--------------------------------------------------------------------------------------------------

Point::Point(double x, double y)
{
  this->x= x;
  this->y= y;
}

//----------------- Size ---------------------------------------------------------------------------

Size::Size()
{
  width= 0;
  height= 0;
}

//--------------------------------------------------------------------------------------------------

Size::Size(double w, double h)
{
  width= w;
  height= h;
}

//--------------------------------------------------------------------------------------------------

bool Size::empty()
{
  return (width == 0) || (height == 0);
}

//----------------- Padding ------------------------------------------------------------------------

Padding::Padding(int padding)
{
  left = padding;
  top = padding;
  right = padding;
  bottom = padding;
}

//--------------------------------------------------------------------------------------------------

Padding::Padding(int left, int top, int right, int bottom)
{
  this->left = left;
  this->top = top;
  this->right = right;
  this->bottom = bottom;
}

//--------------------------------------------------------------------------------------------------

