/* 
 * Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _UTIL_PUBLIC_INTERFACE_H_
#define _UTIL_PUBLIC_INTERFACE_H_

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
#include <winsock2.h>
#endif

#include <util_functions.h>
#include "file_functions.h"
#include <international_file.h>

#ifdef __cplusplus
extern "C" {   
#endif /* __cplusplus */

#define BASE_PUBLIC_INTERFACE_VERSION 10001

/*
 * Enums
 */
typedef enum base_lib_error
{
    BASE_NO_ERROR = 0, BASE_ERROR_CANT_OPEN_FILE, BASE_ERROR_CANT_CONNECT_TO_INSTANCE, BASE_XML_PARSE_ERROR,
    BASE_XML_NO_VALID_DOCUMENT, BASE_XML_EMPTY_DOCUMENT, BASE_SQL_ERROR, BASE_STOP_EXECUTION, BASE_ALLOC_CHANGE_ERROR,
    BASE_OBJECT_NOT_FOUND, BASE_CANT_READ_FROM_FILE, BASE_CHARSET_CONVERSION_ERROR,BASE_CHARSET_WRONG_CHARSET_SPECIFIED,
    BASE_MEMORY_LIMIT_EXCEEDED, BASE_OUT_OF_MEMORY
} BASE_LIB_ERROR;

/*
 * Structs
 */

#ifndef BASE_STRINGLIST_DECLARED
typedef struct {
    unsigned int strings_num;
    char **strings;
} BASE_STRINGLIST;
#define BASE_STRINGLIST_DECLARED
#endif

typedef struct {
  char *name;
  char *value;
} BASE_NAME_VALUE_PAIR;

// ------------------------------
// International File

typedef struct intl_file BASE_INTL_FILE;

/*
 * Functions
 */

BASELIBRARY_PUBLIC_FUNC int get_base_public_interface_version();

/* International file functions */
BASELIBRARY_PUBLIC_FUNC BASE_INTL_FILE * new_intl_file(const char *filename, const char *charset, BASE_LIB_ERROR *error);
BASELIBRARY_PUBLIC_FUNC void free_intl_file(BASE_INTL_FILE *intl_file);
BASELIBRARY_PUBLIC_FUNC bigint read_char_from_intl_file(BASE_INTL_FILE *intl_file, int *bytes_read, BASE_LIB_ERROR *error);

BASELIBRARY_PUBLIC_FUNC char *intl_fgets(char *string, int n, FILE *stream);
BASELIBRARY_PUBLIC_FUNC void intl_rewind(FILE *stream);
BASELIBRARY_PUBLIC_FUNC void intl_skip(FILE *stream, int count);

BASELIBRARY_PUBLIC_FUNC char * escape_string(const char* source);
BASELIBRARY_PUBLIC_FUNC char * escape_string_for_search(const char* source);

BASELIBRARY_PUBLIC_FUNC char* baseconv(ubigint num, int base);

BASELIBRARY_PUBLIC_FUNC const char *stristr(const char *haystack, const char *needle);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
