/*
 *  mdc_interaction_layer.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/Mar/13.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#ifndef _MDC_INTERACTION_LAYER_H_
#define _MDC_INTERACTION_LAYER_H_

#include "mdc_layer.h"

BEGIN_MDC_DECLS

class ItemHandle;


class MYSQLCANVAS_PUBLIC_FUNC InteractionLayer : public Layer 
{
public:
  InteractionLayer(CanvasView *view);

  virtual void repaint(const Rect &bounds);

  void add_handle(ItemHandle *handle);
  void remove_handle(ItemHandle *handle);
  ItemHandle *get_handle_at(const Point &pos);

  void set_active_area(const Rect &rect);
  void reset_active_area();

  bool handle_mouse_move(const Point &pos, EventState state);
  bool handle_mouse_button_top(MouseButton button, bool press, const Point &pos, EventState state);
  bool handle_mouse_button_bottom(MouseButton button, bool press, const Point &pos, EventState state);

  void start_selection_rectangle(const Point &pos, EventState state);
  void update_selection_rectangle(const Point &end, EventState state);
  void end_selection_rectangle(const Point &pos, EventState state);

  void start_dragging_rectangle(const Point &pos);
  void update_dragging_rectangle(const Point &pos);
  void draw_dragging_rectangle();
  Rect finish_dragging_rectangle();

  sigc::signal<void, CairoCtx*> signal_custom_repaint() { return _custom_repaint; }

protected:
  std::list<ItemHandle*> _handles;
  ItemHandle *_dragging_handle;
  Point _dragging_pos;

  sigc::signal<void, CairoCtx*> _custom_repaint;

  Rect _active_area;
  
  Point _selection_start;
  Point _selection_end;
  bool _selection_started;
  bool _selection_started_by_us;

  Point _dragging_rectangle_start;
  Point _dragging_rectangle_end;
  bool _dragging_rectangle;

  void draw_selection(const Rect &clip);
};

END_MDC_DECLS

#endif
