#ifndef _MDC_ITEM_HANDLE_H_
#define _MDC_ITEM_HANDLE_H_

#include "mdc_common.h"

BEGIN_MDC_DECLS

class InteractionLayer;
class CanvasItem;

class MYSQLCANVAS_PUBLIC_FUNC ItemHandle {
public:
  ItemHandle(InteractionLayer *ilayer, CanvasItem *item, const Point &pos);
  virtual ~ItemHandle();
  
  virtual void repaint(CairoCtx *cr);
  virtual Rect get_bounds() const= 0;

  void move(const Point &point);
  Point get_position() const { return _pos; };
    
  CanvasItem *get_item() const { return _item; };
  
  void set_highlighted(bool flag);
  void set_draggable(bool flag);
  bool is_draggable() { return _draggable; }

  void set_tag(int tag) { _tag= tag; };
  inline int get_tag() { return _tag; };

  void set_color(const Color &color);
  void paint_gl(Rect& r);
protected:
  CanvasItem *_item;
  InteractionLayer *_layer;
  Color _color;
  GLuint _display_list;
  bool _dirty;

  Point _pos;
  
  int _tag;
  
  bool _highlighted;
  bool _draggable;
};


END_MDC_DECLS

#endif
