/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include <mforms/appview.h>
#include <mforms/mforms.h>

using namespace mforms;

//--------------------------------------------------------------------------------------------------

#ifdef _WIN32

AppView::AppView(bool horiz, const std::string &context_name, bool is_main)
  : Box(horiz), _context_name(context_name), _is_main(is_main)
{
  _app_view_impl= &ControlFactory::get_instance()->_app_view_impl;
  if (_app_view_impl && _app_view_impl->create)
    _app_view_impl->create(this, horiz);
}

#endif

//--------------------------------------------------------------------------------------------------

