//
//  MFImageBox.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 8/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFImageBox.h"
#import "MFView.h"
#include "mforms/mforms.h"
#include "mforms/app.h"


@implementation MFImageBoxImpl

- (id)initWithObject:(::mforms::ImageBox*)aImage
{
  self= [super initWithFrame:NSMakeRect(10,10,10,10)];
  if (self)
  {
    [self setTag: 0];
    [self setImageFrameStyle: NSImageFrameNone];
    mOwner= aImage;
    mOwner->set_data(self);
    mScale= NO;
  }
  return self;
}


- (mforms::Object*)mformsObject
{
  return mOwner;
}



- (NSSize)minimumSize
{
  if (!mScale)
    return [[self image] size];
  else
    return [super minimumSize];
}



static bool imagebox_create(mforms::ImageBox *image)
{
  [[[MFImageBoxImpl alloc] initWithObject:image] autorelease];
  
  return true;
}


static void imagebox_set_image(mforms::ImageBox *self, const std::string &file)
{
  if (self)
  {
    MFImageBoxImpl *impl= self->get_data();
    NSSize oldSize= [impl frame].size;
    
    std::string full_path= mforms::App::get()->get_resource_path(file);
    NSImage *image= [[[NSImage alloc] initWithContentsOfFile:wrap_nsstring(full_path)] autorelease];
    [impl setImage: image];

    if (!NSEqualSizes([image size], oldSize))
      [[impl superview] subviewMinimumSizeChanged];
  }
}


static void imagebox_set_alignment(mforms::ImageBox *self, mforms::Alignment alignment)
{
  if (self)
  {
    MFImageBoxImpl *impl= self->get_data();
    switch (alignment)
    {
      case mforms::BottomLeft:
        [impl setImageAlignment: NSImageAlignBottomLeft];
        break;
      case mforms::MiddleLeft:
        [impl setImageAlignment: NSImageAlignLeft];
        break;
      case mforms::TopLeft:
        [impl setImageAlignment: NSImageAlignTopLeft];
        break;
      case mforms::BottomCenter:
        [impl setImageAlignment: NSImageAlignBottom];
        break;
      case mforms::TopCenter:
        [impl setImageAlignment: NSImageAlignTop];
        break;
      case mforms::MiddleCenter:
        [impl setImageAlignment: NSImageAlignCenter];
        break;
      case mforms::BottomRight:
        [impl setImageAlignment: NSImageAlignBottomRight];
        break;
      case mforms::MiddleRight:
        [impl setImageAlignment: NSImageAlignRight];
        break;
      case mforms::TopRight:
        [impl setImageAlignment: NSImageAlignTopRight];
        break;
      case mforms::WizardLabelAlignment:
        break;
    }
  }  
}


static void imagebox_set_scale(mforms::ImageBox *self, bool flag)
{
  if (self)
  {
    MFImageBoxImpl *impl= self->get_data();
    impl->mScale= flag;
  }
}

void cf_imagebox_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_imagebox_impl.create= &imagebox_create;
  f->_imagebox_impl.set_image= &imagebox_set_image;  
  f->_imagebox_impl.set_image_align= &imagebox_set_alignment;
  f->_imagebox_impl.set_scale_contents= &imagebox_set_scale;
}

@end
