/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import "MHudController.h"

//--------------------------------------------------------------------------------------------------

@implementation MHudController

static MHudController* instance = nil;

+ (void) showHudWithTitle: (NSString*) title andDescription: (NSString*) description
{
  // TODO: perhaps this should be made thread safe (even tho it must never be called outside the main thread)?
  if (instance == nil)
    instance = [[MHudController alloc] init];

  NSWindow* mainWindow = [[NSApplication sharedApplication] mainWindow];
  if (mainWindow != nil)
  {
    // The applications main window can be nil if the app has not finished loading or is hidden.
    // In those cases we don't need to show the hud either.
    NSRect parentFrame = [mainWindow frame];
    NSSize popupSize = [[instance hud] frame].size;
    NSRect newFrame = NSMakeRect(parentFrame.origin.x + (parentFrame.size.width - popupSize.width) / 2,
                                 parentFrame.origin.y + (parentFrame.size.height - popupSize.height) / 2,
                                 popupSize.width, popupSize.height);
    [instance showAnimatedWithFrame: newFrame title: title andDescription: description];
  }
}

//--------------------------------------------------------------------------------------------------

+ (BOOL) hideHud
{
  if (instance != nil)
  {
    BOOL result = [[instance hud] isVisible];
    if (result)
      [instance hideAnimated];
    return result;
  }
  return NO;
}

//--------------------------------------------------------------------------------------------------

- (id) init
{
  if ((self= [super init]) != nil)
  {
    if (![NSBundle loadNibNamed: @"Components" owner: self])
      NSLog(@"Error loading Components.xib");

    [hudPanel setBecomesKeyOnlyIfNeeded: YES];
  }
  return self;
}

//--------------------------------------------------------------------------------------------------

- (NSPanel*) hud
{
  return hudPanel;
}

//--------------------------------------------------------------------------------------------------

- (void) showAnimatedWithFrame: (NSRect) frame title: (NSString*) title andDescription: (NSString*) description
{
  [shortHudDescription setStringValue: title];
  [longHudDescription setStringValue: description];

  [hudPanel setAlphaValue: 1];
  [hudPanel setFrame: frame display: NO];
  [hudPanel makeKeyAndOrderFront: nil];
  
  [[NSAnimationContext currentContext] setDuration: 0.5];
  [[hudPanel animator] setAlphaValue: 1];
}

//--------------------------------------------------------------------------------------------------

- (void) orderOutPanel
{
  [hudPanel orderOut: nil];
}

//--------------------------------------------------------------------------------------------------

- (void) hideAnimated
{
  [[NSAnimationContext currentContext] setDuration: 0.5];
  [[hudPanel animator] setAlphaValue: 0];
  [self performSelector: @selector(orderOutPanel) withObject: nil afterDelay: 0.5];
}

//--------------------------------------------------------------------------------------------------

@end
