/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "stdafx.h"

#include <mforms/mforms.h>


using namespace mforms;


Panel::Panel(PanelType type)
{
  _panel_impl= &ControlFactory::get_instance()->_panel_impl;

  _panel_impl->create(this, type);
}


void Panel::set_title(const std::string &title)
{
  _panel_impl->set_title(this, title);
}


void Panel::set_back_color(const std::string &color)
{
  _panel_impl->set_back_color(this, color);
}


void Panel::set_active(bool flag)
{
  _panel_impl->set_active(this, flag);
}


bool Panel::get_active()
{
  return _panel_impl->get_active(this);
}


void Panel::add(View *subview)
{
  subview->retain();
  
  subview->set_parent(this);
  (*_panel_impl->add)(this, subview);
  subview->show();
  add_subview(subview);
  
  needs_resize();
}


void Panel::remove(View *subview)
{  
  subview->set_parent(0);
  remove_subview(subview);
  (*_panel_impl->remove)(this, subview);
 
  if (subview)
    subview->release();

  needs_resize();
}


void Panel::set_padding(int pad)
{
  (*_panel_impl->set_padding)(this, pad);
}


void Panel::check_toggled()
{
  _signal_toggled.emit();
}
